/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.lianlian.platform.Encryption;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LianLianPhonebillSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(LianLianPhonebillSupplier2.class);
    private String ip;
    private String terminalId;
    private String username;
    private String payPassword;
    private String key;
    private String buyProduct;
    private String asyncBuyProduct;
    private String buyQuery;
    private String notifyUrl;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-lianlian-new")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u8fde\u8fde\u8bdd\u8d39\u5145\u503c\u8ba2\u5355");
        }
        BaseSupplierExchangeResponse resp = new BaseSupplierExchangeResponse();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String prodId = sp.getProductId();
        String orderid = order.getOrderNum();
        String partnerSystemTime = format.format(order.getGmtCreate());
        String opMoney = sp.getFacePrice() / 100 + "";
        String mobilenum = order.getBizParams().split(":")[0];
        String payPassword = Encryption.encrypt((String)this.key, (String)this.payPassword);
        String sign = LianLianPhonebillSupplier2.md5(LianLianPhonebillSupplier2.md5(this.username + "|" + this.terminalId + "|" + orderid + "|" + partnerSystemTime + "|" + 180 + "|" + prodId + "|" + mobilenum + "|" + opMoney + "|" + payPassword).toLowerCase() + "|" + this.key).toLowerCase();
        String url = this.buyProduct;
        if (!this.buyProduct.endsWith("?")) {
            url = url + "?";
        }
        String tempUrl = url = url + "partnerId=" + this.username + "&terminalId=" + this.terminalId + "&partnerStreamNumber=" + orderid + "&partnerSystemTime=" + partnerSystemTime + "&timeLimit=180&productId=" + prodId + "&customerPhone=" + mobilenum + "&opMoney=" + opMoney + "&payPassword=" + payPassword + "&sign=" + sign;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(url);
            get.setConfig(this.getTimeoutConfig());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            so.setSupplierInfo(body);
            resp.setSupplierBody(body);
            JSONObject json = JSONObject.parseObject((String)body);
            if ("90000000".equals(json.get((Object)"rtnCode"))) {
                resp.setSupplierBody(body);
                JSONObject json2 = JSONObject.parseObject((String)String.valueOf(json.get((Object)"buyProductResult")));
                resp.setSupplierBizId(String.valueOf(json2.get((Object)"streamNumber")));
                if (String.valueOf(json2.get((Object)"tradeStatus")).contains("FAILED") || String.valueOf(json2.get((Object)"tradeStatus")).contains("TIMEOUT")) {
                    String msg = String.valueOf(json2.get((Object)"tradeMessage"));
                    resp.setError4Admin("\u8fde\u8fde\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
                    resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
                    resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    resp.setFail(true);
                }
            } else {
                resp.setSupplierBody(body);
                String msg = String.valueOf(json.get((Object)"rtnMsg"));
                resp.setError4Admin("\u8fde\u8fde\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
                resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                resp.setFail(true);
            }
        }
        finally {
            so.setStatus("send");
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus(so.getStatus());
            so4u.setSendTime(so.getSendTime());
            so4u.setSupplierInfo(so.getSupplierInfo());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(tempUrl);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        String sign;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-lianlian-new")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u8fde\u8fde\u8bdd\u8d39\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String prodId = sp.getProductId();
        String orderid = order.getOrderNum();
        String partnerSystemTime = format.format(new Date());
        String opMoney = sp.getFacePrice() / 100 + "";
        String mobilenum = order.getBizParams().split(":")[0];
        String payPassword = Encryption.encrypt((String)this.key, (String)this.payPassword);
        try {
            sign = LianLianPhonebillSupplier2.md5(LianLianPhonebillSupplier2.md5(this.username + "|" + this.terminalId + "|" + orderid + "|" + partnerSystemTime + "|" + 180 + "|" + prodId + "|" + mobilenum + "|" + opMoney + "|" + payPassword + "|" + this.notifyUrl).toLowerCase() + "|" + this.key).toLowerCase();
        }
        catch (Exception e1) {
            logger.error("md5\u52a0\u5bc6\u5931\u8d25");
            return;
        }
        String url = this.asyncBuyProduct;
        if (!this.buyProduct.endsWith("?")) {
            url = url + "?";
        }
        String urlTemp = url = url + "partnerId=" + this.username + "&terminalId=" + this.terminalId + "&partnerStreamNumber=" + orderid + "&partnerSystemTime=" + partnerSystemTime + "&timeLimit=180&productId=" + prodId + "&customerPhone=" + mobilenum + "&opMoney=" + opMoney + "&payPassword=" + payPassword + "&notifyUrl=" + this.notifyUrl + "&sign=" + sign;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(urlTemp);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phonebill-lianlian-new");
        try {
            this.messageService.sendMsg(this.topicConstant.getPhonebillRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhonebillLianlian sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String sign = LianLianPhonebillSupplier2.md5(LianLianPhonebillSupplier2.md5(this.username + "|" + this.terminalId + "|" + orderNum + "|" + "20150827000000" + "|" + "20500827000000").toLowerCase() + "|" + this.key).toLowerCase();
        String url = this.buyQuery;
        if (!this.buyQuery.endsWith("?")) {
            url = url + "?";
        }
        url = url + "partnerId=" + this.username + "&terminalId=" + this.terminalId + "&partnerStreamNumber=" + orderNum + "&startTime=" + "20150827000000" + "&endTime=" + "20500827000000" + "&sign=" + sign;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)resp.getEntity());
        status.setResponse(body);
        String returnStatus = "";
        JSONObject json = JSONObject.parseObject((String)body);
        JSONObject json2 = JSONObject.parseObject((String)String.valueOf(json.get((Object)"buyRecord")));
        if (String.valueOf(json2.get((Object)"tradeStatus")).contains("FAILED") || String.valueOf(json2.get((Object)"tradeStatus")).contains("TIMEOUT")) {
            String msg = String.valueOf(json2.get((Object)"tradeMessage"));
        }
        if (String.valueOf(json2.get((Object)"tradeStatus")).contains("SUCCESS")) {
            status.setSuccess(true);
        } else if (String.valueOf(json2.get((Object)"tradeStatus")).contains("FAILED")) {
            status.setFail(true);
        } else if (String.valueOf(json2.get((Object)"tradeStatus")).contains("TIMEOUT")) {
            status.setFail(true);
        } else if (String.valueOf(json2.get((Object)"tradeStatus")).contains("PROCESS")) {
            status.setProcessing(true);
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("partnerStreamNumber");
        String status = request.getParameter("status");
        if (!Environment.isDaily() && !this.ip.equals(RequestTool.getIpAddr(request))) {
            throw new Exception("\u5f02\u6b65\u901a\u77e5\u6765\u6e90\u9519\u8bef");
        }
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phonebill-lianlian-new".equals(sp.getSupplier())) {
            if ("SUCCESS".equals(status)) {
                ret.setSuccess(true);
            } else if ("FAILED".equals(status)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "lianlian";
    }

    public static String md5(String content) throws Exception {
        return LianLianPhonebillSupplier2.toHexValue(LianLianPhonebillSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String getKeyedDigest(String strSrc, String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(strSrc.getBytes("UTF8"));
            String result = "";
            byte[] temp = md5.digest(key.getBytes("UTF8"));
            for (int i = 0; i < temp.length; ++i) {
                result = result + Long.toHexString(0xFF & temp[i] | 0xFFFFFF00).substring(6);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCodeMessage(String code) {
        if ("90000000".equals(code)) {
            return "\u64cd\u4f5c\u6210\u529f";
        }
        if ("90000001".equals(code)) {
            return "\u7f3a\u5c11\u5fc5\u9700\u53c2\u6570";
        }
        if ("90000002".equals(code)) {
            return "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("90000003".equals(code)) {
            return "\u5546\u54c1\u4e0d\u5b58\u5728";
        }
        if ("90000004".equals(code)) {
            return "\u65e0\u6548\u7684\u5546\u6237\u7cfb\u7edf\u65f6\u95f4";
        }
        if ("90000005".equals(code)) {
            return "\u975e\u6cd5\u7684ip\u5730\u5740";
        }
        if ("90000006".equals(code)) {
            return "\u8ba2\u5355\u4e0d\u5b58\u5728";
        }
        if ("90000007".equals(code)) {
            return "\u4e0b\u5355\u5931\u8d25\u7684\u5177\u4f53\u539f\u56e0";
        }
        if ("90000008".equals(code)) {
            return "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
        }
        if ("90000009".equals(code)) {
            return "\u65e0\u6b64\u53f7\u6bb5\u4fe1\u606f";
        }
        if ("90000010".equals(code)) {
            return "\u670d\u52a1\u672a\u5f00\u901a";
        }
        if ("90000011".equals(code)) {
            return "\u5f53\u65e5\u91cd\u590d\u7684\u5546\u6237\u6d41\u6c34\u53f7";
        }
        if ("90000012".equals(code)) {
            return "\u65e0\u6548\u7684\u77ed\u4fe1\u7c7b\u578b\u4ee3\u7801";
        }
        return null;
    }

    public static SupplierData.SupplierExchangeRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPayPassword() {
        return this.payPassword;
    }

    public void setPayPassword(String payPassword) {
        this.payPassword = payPassword;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getBuyProduct() {
        return this.buyProduct;
    }

    public void setBuyProduct(String buyProduct) {
        this.buyProduct = buyProduct;
    }

    public String getAsyncBuyProduct() {
        return this.asyncBuyProduct;
    }

    public void setAsyncBuyProduct(String asyncBuyProduct) {
        this.asyncBuyProduct = asyncBuyProduct;
    }

    public String getBuyQuery() {
        return this.buyQuery;
    }

    public void setBuyQuery(String buyQuery) {
        this.buyQuery = buyQuery;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        JSONObject json = JSONObject.parseObject((String)body);
        if ("90000000".equals(json.get((Object)"rtnCode"))) {
            JSONObject json2 = JSONObject.parseObject((String)String.valueOf(json.get((Object)"buyProductResult")));
            resp.setSupplierBizId(String.valueOf(json2.get((Object)"streamNumber")));
        } else {
            String msg = String.valueOf(json.get((Object)"rtnMsg"));
            resp.setError4Admin("\u8fde\u8fde\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        so4u.setSupplierInfo(resp.getBody());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class PhonebillExchangeRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto sp;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.sp;
        }

        public void setSupplierProduct(SupplierProductDto sp) {
            this.sp = sp;
        }
    }
}

