/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.AESUtils;
import cn.com.duiba.order.center.biz.tool.RequestTool;
import cn.com.duiba.order.center.biz.tool.SignatureUtils;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MoPinPhoneflowSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(MoPinPhoneflowSupplier2.class);
    private String cpApiKey;
    private String cpSecretKey;
    private String notifyUrl;
    private String cpUser;
    private String buyProduct;
    private String queryUrl;
    private String ip;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static MoPinPhoneflowRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        MoPinPhoneflowRequest req = new MoPinPhoneflowRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        MoPinPhoneflowResponse resp = new MoPinPhoneflowResponse();
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phoneflow-mopin")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u9b54\u54c1\u624b\u673a\u6d41\u91cf\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String url = this.buyProduct;
        if (!this.buyProduct.endsWith("?")) {
            url = url + "?";
        }
        String ciphertext = "";
        String digest = "";
        String signature = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String spTime = sdf.format(new Date());
        JSONObject content = new JSONObject();
        String cardid = sp.getProductId();
        String sporder_id = so.getDuibaOrderNum();
        String mobilenum = order.getBizParams().split(":")[0];
        long millis = System.currentTimeMillis();
        content.put("cpUser", (Object)this.cpUser);
        content.put("channelOrderId", (Object)sporder_id);
        content.put("createTime", (Object)spTime);
        content.put("type", (Object)1);
        content.put("amount", (Object)Long.valueOf(cardid));
        content.put("range", (Object)0);
        content.put("mobile", (Object)mobilenum);
        content.put("notifyUrl", (Object)this.notifyUrl);
        try {
            ciphertext = AESUtils.encrypt(content.toJSONString(), this.cpApiKey);
        }
        catch (Exception e1) {
            logger.error("AESUtils\u52a0\u5bc6\u5931\u8d25");
        }
        digest = SignatureUtils.digest(ciphertext);
        signature = SignatureUtils.signature(this.cpUser, this.cpSecretKey, digest, millis);
        String postUrl = url + "a=" + this.cpUser + "&d=" + digest + "&t=" + millis + "&s=" + signature;
        if (Environment.isDaily()) {
            postUrl = postUrl + "&channelOrderId=" + sporder_id;
        }
        String completeUrl = postUrl;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phoneflow-mopin");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("digest", digest);
        params.put("signature", signature);
        params.put("ciphertext", ciphertext);
        srequest.setParams(params);
        try {
            this.messageService.sendMsg(this.topicConstant.getPhoneflowRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhoneflowMoPin sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String orderQuery = this.queryUrl;
        if (!orderQuery.endsWith("?")) {
            orderQuery = orderQuery + "?";
        }
        String queryUrl = orderQuery + "orderId=" + orderNum + "&cpUser=" + this.cpUser;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(queryUrl);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        status.setResponse(body);
        if ("1".equals(body)) {
            status.setSuccess(true);
        } else if ("0".equals(body)) {
            status.setFail(true);
        } else if ("2".equals(body)) {
            status.setProcessing(true);
        } else {
            throw new Exception(body);
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        return null;
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        String status;
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getAttribute("channelOrderId") != null ? String.valueOf(request.getAttribute("channelOrderId")) : null;
        String string = status = request.getAttribute("status") != null ? String.valueOf(request.getAttribute("status")) : null;
        if (!Environment.isDaily() && !this.ip.equals(RequestTool.getIpAddr(request))) {
            throw new Exception("\u5f02\u6b65\u901a\u77e5\u6765\u6e90\u9519\u8bef");
        }
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phoneflow-mopin".equals(sp.getSupplier())) {
            if ("1".equals(status)) {
                ret.setSuccess(true);
            } else if ("0".equals(status)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "mopin-phoneflow";
    }

    public static String md5(String content) throws Exception {
        return MoPinPhoneflowSupplier2.toHexValue(MoPinPhoneflowSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public String getBuyProduct() {
        return this.buyProduct;
    }

    public void setBuyProduct(String buyProduct) {
        this.buyProduct = buyProduct;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getCpApiKey() {
        return this.cpApiKey;
    }

    public void setCpApiKey(String cpApiKey) {
        this.cpApiKey = cpApiKey;
    }

    public String getCpSecretKey() {
        return this.cpSecretKey;
    }

    public void setCpSecretKey(String cpSecretKey) {
        this.cpSecretKey = cpSecretKey;
    }

    public String getCpUser() {
        return this.cpUser;
    }

    public void setCpUser(String cpUser) {
        this.cpUser = cpUser;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public static String getDataCodeMessage(String code) {
        if ("1000".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u5931\u8d25";
        }
        if ("1001".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u7684\u624b\u673a\u53f7\u7801\u4e3a\u7a7a";
        }
        if ("1002".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u7684\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e\u6216\u4e0d\u652f\u6301";
        }
        if ("1003".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\u4e3a\u7a7a";
        }
        if ("1004".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\u8d85\u51fa\u6700\u5927\u957f\u5ea6\uff0830\u4f4d\uff09";
        }
        if ("1005".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u56de\u8c03\u5730\u5740\u4e3a\u7a7a";
        }
        if ("1006".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u9762\u503c\u683c\u5f0f\u4e0d\u6b63\u786e";
        }
        if ("1007".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u7c7b\u578b\u4e0d\u6b63\u786e";
        }
        if ("1008".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u8ba2\u5355\u91cd\u590d";
        }
        if ("1009".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u8ba2\u5355";
        }
        if ("1010".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u67e5\u8be2\u533a\u57df\u4e3a\u7a7a";
        }
        if ("1011".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u8d26\u6237\u4f59\u989d\u4e0d\u8db3";
        }
        if ("1012".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u6263\u6b3e\u5931\u8d25";
        }
        if ("1013".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u9000\u6b3e\u5931\u8d25";
        }
        if ("1014".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u9000\u6b3e\u6210\u529f";
        }
        if ("1015".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u6240\u5145\u503c\u7684\u4ea7\u54c1\u4e0d\u5b58\u5728";
        }
        if ("1016".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u6240\u5145\u503c\u7684\u4ea7\u54c1\u6ca1\u6709\u62a5\u4ef7\u4fe1\u606f";
        }
        if ("1017".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574";
        }
        if ("1018".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u5145\u503c\u6e20\u9053\u6682\u4e0d\u53ef\u7528";
        }
        if ("1019".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u6d41\u91cf\u5305\u53ef\u5145\u503c\u8303\u56f4\u4e3a\u7a7a";
        }
        if ("1020".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u4e0e\u5145\u503c\u8303\u56f4\u5339\u914d\u7684\u6d41\u91cf\u5305";
        }
        if ("----".equals(code)) {
            return "\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\u4e0d\u660e";
        }
        return null;
    }

    public static String getCodeMessage(String code) {
        if ("500".equals(code)) {
            return "\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u4e0d\u660e\u786e";
        }
        if ("406".equals(code)) {
            return "\u7cfb\u7edf\u5f53\u524d\u5904\u4e8e\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u6c42\u62d2\u7edd";
        }
        if ("900".equals(code)) {
            return "\u6ca1\u6709\u6743\u9650";
        }
        if ("3000".equals(code)) {
            return "\u975e\u6cd5\u8bf7\u6c42";
        }
        if ("3001".equals(code)) {
            return "\u8bf7\u6c42\u5185\u5bb9\u4e3a\u7a7a";
        }
        if ("3002".equals(code)) {
            return "\u975e\u6cd5\u7684token";
        }
        if ("3003".equals(code)) {
            return "\u975e\u6cd5\u7684\u8bf7\u6c42\u53c2\u6570";
        }
        if ("3004".equals(code)) {
            return "\u975e\u6cd5\u7684\u6570\u5b57\u7b7e\u540d";
        }
        if ("3005".equals(code)) {
            return "\u975e\u6cd5\u7684\u6458\u8981";
        }
        if ("3006".equals(code)) {
            return "\u975e\u6cd5\u7684\u5f00\u53d1\u8005\u5bc6\u94a5";
        }
        if ("3007".equals(code)) {
            return "\u975e\u6cd5\u7684\u6570\u5b57\u7b7e\u540d\u5bc6\u94a5";
        }
        if ("3008".equals(code)) {
            return "\u5546\u6237\u88ab\u7981\u7528";
        }
        if ("3009".equals(code)) {
            return "\u9ed1\u540d\u5355\u7528\u6237";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        JSONObject json = JSONObject.parseObject((String)resp.getBody());
        JSONObject json2 = JSONObject.parseObject((String)String.valueOf(json.get((Object)"data")));
        if ("200".equals(String.valueOf(json.get((Object)"statusCode"))) && !StringUtils.isBlank((String)String.valueOf(json2.get((Object)"orderId"))) && "0000".equals(json2.get((Object)"status"))) {
            resp.setSupplierBizId(String.valueOf(json2.get((Object)"orderId")));
        } else {
            String msg = StringUtils.isBlank((String)String.valueOf(json.get((Object)"message") == null ? "" : json.get((Object)"message"))) ? (StringUtils.isBlank((String)String.valueOf(json2.get((Object)"status"))) ? MoPinPhoneflowSupplier2.getCodeMessage(String.valueOf(json.get((Object)"statusCode"))) : MoPinPhoneflowSupplier2.getDataCodeMessage(String.valueOf(json2.get((Object)"status")))) : String.valueOf(json.get((Object)"message"));
            resp.setError4Admin("\u9b54\u54c1\u6d41\u91cf\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so = this.supplierOrdersService.find(Long.valueOf(resp.getSupplierOrderId()));
        if ("create".equals(so.getStatus())) {
            so.setStatus("send");
        }
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSendTime(so.getSendTime());
        so4u.setStatus(so.getStatus());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class MoPinPhoneflowResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class MoPinPhoneflowRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto supplierProduct;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.supplierProduct;
        }

        public void setSupplierProduct(SupplierProductDto supplierProduct) {
            this.supplierProduct = supplierProduct;
        }
    }
}

