/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.exchange2.tool.TripleDESUtil;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewLianLianPhonebillSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(NewLianLianPhonebillSupplier2.class);
    private String partnerId;
    private String orgcode;
    private String agentId;
    private String password;
    private String payPassword;
    private String key;
    private String charge;
    private String query;
    private String account;
    private String ip;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;
    public static TripleDESUtil TDES = TripleDESUtil.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-lianlian-new-platform")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u8fde\u8fde\u8bdd\u8d39\u5145\u503c\u8ba2\u5355");
        }
        BaseSupplierExchangeResponse resp = new BaseSupplierExchangeResponse();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String orderNum = order.getOrderNum();
        String facePrice = sp.getFacePrice() / 100 + "";
        String mobilenum = order.getBizParams().split(":")[0];
        String timestamp = format.format(new Date());
        String payPassword = TDES.encrypt(this.payPassword, this.key);
        String password = TDES.encrypt(this.password, this.key);
        String signType = "MD5";
        String url = this.charge;
        String sign = "account_no=" + mobilenum + "&agent_id=" + this.agentId + "&face_price=" + facePrice + "&order_no=" + orderNum + "&orgcode=" + this.orgcode + "&partner_id=" + this.partnerId + "&password=" + password + "&pay_password=" + payPassword + "&sign_type=" + signType + "&timestamp=" + timestamp + this.key;
        String signMd5 = NewLianLianPhonebillSupplier2.md5(sign);
        JSONObject headContent = new JSONObject();
        headContent.put("partner_id", (Object)this.partnerId);
        headContent.put("orgcode", (Object)this.orgcode);
        headContent.put("agent_id", (Object)this.agentId);
        headContent.put("password", (Object)password);
        headContent.put("timestamp", (Object)timestamp);
        headContent.put("sign_type", (Object)signType);
        headContent.put("sign", (Object)signMd5);
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("pay_password", (Object)payPassword);
        bodyContent.put("order_no", (Object)orderNum);
        bodyContent.put("account_no", (Object)mobilenum);
        bodyContent.put("face_price", (Object)facePrice);
        JSONObject finalContent = new JSONObject();
        finalContent.put("body", (Object)bodyContent);
        finalContent.put("header", (Object)headContent);
        String tempUrl = url;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(url);
            post.setConfig(this.getTimeoutConfig());
            StringEntity entity = new StringEntity(finalContent.toJSONString(), "UTF-8");
            entity.setContentType("application/json;charset=UTF-8");
            post.setEntity((HttpEntity)entity);
            post.addHeader("Accept", "application/json");
            post.addHeader("ContentType", "application/json;charset=UTF-8");
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            so.setSupplierInfo(body);
            resp.setSupplierBody(body);
            JSONObject json = JSONObject.parseObject((String)body);
            JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(json.get((Object)"result")));
            if ("10000000".equals(resultJson.get((Object)"ret_code"))) {
                resp.setSupplierBody(body);
                JSONObject jsonBody = JSONObject.parseObject((String)String.valueOf(json.get((Object)"body")));
                resp.setSupplierBizId(String.valueOf(jsonBody.get((Object)"stream_id")));
            } else {
                resp.setSupplierBody(body);
                String msg = String.valueOf(json.get((Object)"ret_msg"));
                resp.setError4Admin("\u8fde\u8fde\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
                resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            }
        }
        finally {
            so.setStatus("send");
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus(so.getStatus());
            so4u.setSendTime(so.getSendTime());
            so4u.setSupplierInfo(so.getSupplierInfo());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(tempUrl);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-lianlian-new-platform")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u8fde\u8fde\u8bdd\u8d39\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String orderNum = order.getOrderNum();
        String facePrice = sp.getFacePrice() / 100 + "";
        String mobilenum = order.getBizParams().split(":")[0];
        String timestamp = format.format(new Date());
        String payPassword = null;
        String password = null;
        try {
            payPassword = TDES.encrypt(this.payPassword, this.key);
            password = TDES.encrypt(this.password, this.key);
        }
        catch (Exception e2) {
            logger.error("\u8fde\u8fde\u52a0\u5bc6\u5931\u8d25 ,error:" + e2.getMessage());
            return;
        }
        String signType = "MD5";
        String url = this.charge;
        String sign = "account_no=" + mobilenum + "&agent_id=" + this.agentId + "&face_price=" + facePrice + "&order_no=" + orderNum + "&orgcode=" + this.orgcode + "&partner_id=" + this.partnerId + "&password=" + password + "&pay_password=" + payPassword + "&sign_type=" + signType + "&timestamp=" + timestamp + this.key;
        String signMd5 = null;
        try {
            signMd5 = NewLianLianPhonebillSupplier2.md5(sign);
        }
        catch (Exception e1) {
            logger.error("md5\u52a0\u5bc6\u5931\u8d25");
            return;
        }
        if (Environment.isDaily()) {
            url = url + "?orderNum=" + orderNum;
        }
        JSONObject headContent = new JSONObject();
        headContent.put("partner_id", (Object)this.partnerId);
        headContent.put("orgcode", (Object)this.orgcode);
        headContent.put("agent_id", (Object)this.agentId);
        headContent.put("password", (Object)password);
        headContent.put("timestamp", (Object)timestamp);
        headContent.put("sign_type", (Object)signType);
        headContent.put("sign", (Object)signMd5);
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("pay_password", (Object)payPassword);
        bodyContent.put("order_no", (Object)orderNum);
        bodyContent.put("account_no", (Object)mobilenum);
        bodyContent.put("face_price", (Object)facePrice);
        JSONObject finalContent = new JSONObject();
        finalContent.put("body", (Object)bodyContent);
        finalContent.put("header", (Object)headContent);
        String urlTemp = url;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(urlTemp);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phonebill-lianlian-new-platform");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entity", finalContent.toJSONString());
        srequest.setParams(params);
        try {
            this.messageService.sendMsg(this.topicConstant.getPhonebillRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhonebillNewLianlian sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = format.format(new Date());
        String signType = "MD5";
        String orderType = "01";
        String url = this.charge;
        String sign = "order_no=" + orderNum + "&agent_id=" + this.agentId + "&order_type=" + orderType + "&order_no=" + orderNum + "&orgcode=" + this.orgcode + "&partner_id=" + this.partnerId + "&password=" + this.password + "&sign_type=" + signType + "&timestamp=" + timestamp + this.key;
        String signMd5 = NewLianLianPhonebillSupplier2.md5(sign);
        JSONObject headContent = new JSONObject();
        headContent.put("partner_id", (Object)this.partnerId);
        headContent.put("orgcode", (Object)this.orgcode);
        headContent.put("agent_id", (Object)this.agentId);
        headContent.put("password", (Object)this.password);
        headContent.put("timestamp", (Object)timestamp);
        headContent.put("sign_type", (Object)signType);
        headContent.put("sign", (Object)signMd5);
        JSONObject bodyContent = new JSONObject();
        bodyContent.put("order_no", (Object)orderNum);
        bodyContent.put("order_type", (Object)orderType);
        JSONObject finalContent = new JSONObject();
        finalContent.put("body", (Object)bodyContent);
        finalContent.put("header", (Object)headContent);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)resp.getEntity());
        status.setResponse(body);
        JSONObject json = JSONObject.parseObject((String)body);
        JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(json.get((Object)"result")));
        if ("10000000".equals(resultJson.get((Object)"ret_code"))) {
            JSONObject jsonBody = JSONObject.parseObject((String)String.valueOf(json.get((Object)"body")));
            if (String.valueOf(jsonBody.get((Object)"status")).contains("SUCCESS")) {
                status.setSuccess(true);
            } else if (String.valueOf(jsonBody.get((Object)"status")).contains("FAILED")) {
                status.setFail(true);
            } else if (String.valueOf(jsonBody.get((Object)"status")).contains("PROCESS")) {
                status.setProcessing(true);
            }
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("order_no");
        String status = request.getParameter("status");
        if (!Environment.isDaily() && !this.ip.contains(RequestTool.getIpAddr(request))) {
            throw new Exception("\u5f02\u6b65\u901a\u77e5\u6765\u6e90\u9519\u8bef");
        }
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phonebill-lianlian-new-platform".equals(sp.getSupplier())) {
            if ("SUCCESS".equals(status)) {
                ret.setSuccess(true);
            } else if ("FAILED".equals(status)) {
                ret.setFail(true);
            } else if ("PROCESS".equals(status)) {
                ret.setProcessing(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "lianlianNew";
    }

    public static String md5(String content) throws Exception {
        return NewLianLianPhonebillSupplier2.toHexValue(NewLianLianPhonebillSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String getKeyedDigest(String strSrc, String key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(strSrc.getBytes("UTF8"));
            String result = "";
            byte[] temp = md5.digest(key.getBytes("UTF8"));
            for (int i = 0; i < temp.length; ++i) {
                result = result + Long.toHexString(0xFF & temp[i] | 0xFFFFFF00).substring(6);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCodeMessage(String code) {
        if ("10000000".equals(code)) {
            return "\u4ea4\u6613\u6210\u529f";
        }
        if ("10990001".equals(code)) {
            return "\u5185\u90e8\u901a\u8baf\u5f02\u5e38";
        }
        if ("11310100".equals(code)) {
            return "\u65e0\u660e\u7ec6";
        }
        if ("11310117".equals(code)) {
            return "\u8be5\u6e20\u9053\u7684\u4e1a\u52a1\u5df2\u5173\u95ed";
        }
        if ("11610020".equals(code)) {
            return "\u94b1\u5305\u4f59\u989d\u4e0d\u8db3";
        }
        if ("11610051".equals(code)) {
            return "\u7cfb\u7edf\u6709\u91cd\u590d\u6d41\u6c34\uff0c\u6b64\u6d41\u6c34\u4e0d\u80fd\u518d\u53d1\u8d77\u5145\u503c";
        }
        if ("11610057".equals(code)) {
            return "\u7cfb\u7edf\u8fd0\u7ef4\u65f6\u95f4\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5";
        }
        if ("11810001".equals(code)) {
            return "\u4f9b\u8d27\u5546\u54c1\u4e0d\u5b58\u5728";
        }
        if ("11810004".equals(code)) {
            return "\u8d27\u67b6\u7f16\u53f7\u6216\u8d27\u67b6\u5546\u54c1\u7f16\u53f7\u4e0d\u5b58\u5728";
        }
        if ("11810024".equals(code)) {
            return "\u65e0\u5bf9\u5e94\u53f7\u6bb5\u4fe1\u606f";
        }
        return null;
    }

    public static SupplierData.SupplierExchangeRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getOrgcode() {
        return this.orgcode;
    }

    public void setOrgcode(String orgcode) {
        this.orgcode = orgcode;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPayPassword() {
        return this.payPassword;
    }

    public void setPayPassword(String payPassword) {
        this.payPassword = payPassword;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        JSONObject json = JSONObject.parseObject((String)body);
        JSONObject resultJson = JSONObject.parseObject((String)String.valueOf(json.get((Object)"result")));
        if ("10000000".equals(resultJson.get((Object)"ret_code"))) {
            JSONObject jsonBody = JSONObject.parseObject((String)String.valueOf(json.get((Object)"body")));
            resp.setSupplierBizId(String.valueOf(jsonBody.get((Object)"stream_id")));
        } else {
            String msg = String.valueOf(json.get((Object)"ret_msg"));
            resp.setError4Admin("\u8fde\u8fde\u8bdd\u8d39\u4e0a\u6e38\u54cd\u5e94\u5f02\u5e38\uff1a" + msg);
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5931\u8d25\u3002");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        so4u.setSupplierInfo(resp.getBody());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class PhonebillExchangeRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto sp;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.sp;
        }

        public void setSupplierProduct(SupplierProductDto sp) {
            this.sp = sp;
        }
    }
}

