/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.AlipayOfficialSupplier2;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import com.alibaba.fastjson.JSONObject;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class OufeiPhoneflowSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(AlipayOfficialSupplier2.class);
    private String url;
    private String agentID;
    private String agentPW;
    private String md5Key;
    private String notifyUrl;
    private String orderQuery;
    private String balanceQuery;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static OufeiPhoneflowRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        OufeiPhoneflowRequest req = new OufeiPhoneflowRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest req, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        String postUrl;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phoneflow-oufei")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u6b27\u98de\u624b\u673a\u6d41\u91cf\u5145\u503c\u8ba2\u5355");
        }
        if (!this.url.endsWith("?")) {
            this.url = this.url + "?";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String md5Userpws = OufeiPhoneflowSupplier2.md5(this.agentPW);
        String spTime = sdf.format(order.getGmtCreate());
        String userid = this.agentID;
        String userpws = md5Userpws;
        String cardid = sp.getProductId();
        String cardnum = sp.getFacePrice() / 100 + "";
        String sporder_id = so.getDuibaOrderNum();
        String sporder_time = spTime;
        String mobilenum = order.getBizParams().split(":")[0];
        String md5_str = "";
        String ret_url = this.notifyUrl;
        String version = "6.0";
        md5_str = OufeiPhoneflowSupplier2.md5(userid + userpws + cardid + cardnum + sporder_id + sporder_time + mobilenum + this.md5Key).toUpperCase();
        String completeUrl = postUrl = this.url + "userid=" + userid + "&userpws=" + userpws + "&cardid=" + cardid + "&cardnum=" + cardnum + "&sporder_id=" + sporder_id + "&sporder_time=" + sporder_time + "&game_userid=" + mobilenum + "&md5_str=" + md5_str + "&version=" + version + "&ret_url=" + ret_url;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(postUrl);
        get.setConfig(this.getTimeoutConfig());
        OufeiPhoneflowResponse resp = new OufeiPhoneflowResponse();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            so.setSupplierInfo(body);
            resp.setSupplierBody(body);
            StringReader xmlReader = new StringReader(body);
            InputSource xmlSource = new InputSource(xmlReader);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xmlSource);
            Element root = doc.getRootElement();
            String retcode = root.getChild("retcode").getValue();
            if ((root.getChild("err_msg").getValue() == null || root.getChild("err_msg").getValue().trim().length() == 0) && "1".equals(retcode)) {
                String spOrderId = root.getChild("orderid").getValue();
                String game_state = root.getChild("game_state").getValue();
                if ("1".equals(game_state)) {
                    resp.setSuccess(true);
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                } else if ("0".equals(game_state)) {
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                } else if ("9".equals(game_state)) {
                    resp.setSupplierBizId(spOrderId);
                    resp.setSupplierBody(body);
                    resp.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25,\u8ba2\u5355\u64a4\u9500\uff0c\u53ef\u9000\u6b3e\u3002");
                    resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                    resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                } else {
                    resp.setError4Admin("\u6b27\u98de\u8fd4\u56de\u72b6\u6001\u7801game_state\u4e3a\u672a\u77e5\u5904\u7406\u7c7b\u578b\uff1a" + game_state);
                    resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                    resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            } else if ("105".equals(retcode) || "334".equals(retcode) || "1043".equals(retcode) || "999".equals(retcode)) {
                so.setStatus("send");
                so.setErrorMessage("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u9700\u8c03\u67e5\u8be2\u63a5\u53e3\u786e\u8ba4\u8ba2\u5355\u72b6\u6001");
                so.setSupplierInfo(body);
            } else {
                resp.setSupplierBody(body);
                resp.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38");
                resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ("create".equals(so.getStatus())) {
                so.setStatus("send");
            }
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setSendTime(so.getSendTime());
            so4u.setErrorMessage(so.getErrorMessage());
            so4u.setSupplierInfo(so.getSupplierInfo());
            so4u.setStatus(so.getStatus());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(completeUrl);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                StatHttpRequestLog.log(log);
            }
        }
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        String postUrl;
        String md5Userpws;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phoneflow-oufei")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u6b27\u98de\u624b\u673a\u6d41\u91cf\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        if (!this.url.endsWith("?")) {
            this.url = this.url + "?";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            md5Userpws = OufeiPhoneflowSupplier2.md5(this.agentPW);
        }
        catch (Exception e2) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(e2);
                }
            });
            return;
        }
        String spTime = sdf.format(order.getGmtCreate());
        String userid = this.agentID;
        String userpws = md5Userpws;
        String cardid = sp.getProductId();
        String cardnum = sp.getFacePrice() / 100 + "";
        String sporder_id = so.getDuibaOrderNum();
        String sporder_time = spTime;
        String mobilenum = order.getBizParams().split(":")[0];
        String md5_str = "";
        String ret_url = this.notifyUrl;
        String version = "6.0";
        try {
            md5_str = OufeiPhoneflowSupplier2.md5(userid + userpws + cardid + cardnum + sporder_id + sporder_time + mobilenum + this.md5Key).toUpperCase();
        }
        catch (Exception e1) {
            callback.onException(e1);
            return;
        }
        String completeUrl = postUrl = this.url + "userid=" + userid + "&userpws=" + userpws + "&cardid=" + cardid + "&cardnum=" + cardnum + "&sporder_id=" + sporder_id + "&sporder_time=" + sporder_time + "&game_userid=" + mobilenum + "&md5_str=" + md5_str + "&version=" + version + "&ret_url=" + ret_url;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(completeUrl);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phoneflow-oufei");
        try {
            this.messageService.sendMsg(this.topicConstant.getPhoneflowRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhoneflowOufei sendMsg:", (Throwable)e);
        }
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        status.setOrderNum(orderNum);
        status.setSupplierOrderId(supplierOrderId);
        String orderQuery = this.orderQuery;
        if (!orderQuery.endsWith("?")) {
            orderQuery = orderQuery + "?";
        }
        String queryUrl = orderQuery + "userid=" + this.agentID + "&spbillid=" + orderNum;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(queryUrl);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        status.setResponse(body);
        if ("1".equals(body)) {
            status.setSuccess(true);
        } else if ("9".equals(body)) {
            status.setFail(true);
        } else if ("0".equals(body)) {
            status.setProcessing(true);
        } else if ("-1".equals(body)) {
            status.setNotExist(true);
        } else {
            throw new Exception(body);
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        HttpGet get;
        String balanceQuery = this.balanceQuery;
        if (!balanceQuery.endsWith("?")) {
            balanceQuery = balanceQuery + "?";
        }
        String body = "";
        String md5Userpws = OufeiPhoneflowSupplier2.md5(this.agentPW);
        balanceQuery = balanceQuery + "userid=" + this.agentID + "&userpws=" + md5Userpws + "&version=6.0";
        SAXBuilder builder = new SAXBuilder();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(get = new HttpGet(balanceQuery)));
        body = EntityUtils.toString((HttpEntity)response.getEntity());
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        if (root.getChild("retcode").getValue().equals("1")) {
            String balance = root.getChild("ret_leftcredit").getValue();
            BigDecimal bd = new BigDecimal(balance);
            return bd;
        }
        return null;
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("sporder_id");
        String status = request.getParameter("ret_code");
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phoneflow-oufei".equals(sp.getSupplier())) {
            if ("1".equals(status)) {
                ret.setSuccess(true);
            } else if ("9".equals(status)) {
                ret.setFail(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "oufei-phoneflow";
    }

    public static String md5(String content) throws Exception {
        return OufeiPhoneflowSupplier2.toHexValue(OufeiPhoneflowSupplier2.encryptMD5(content.getBytes(Charset.forName("utf-8"))));
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    public String getAgentPW() {
        return this.agentPW;
    }

    public void setAgentPW(String agentPW) {
        this.agentPW = agentPW;
    }

    public String getMd5Key() {
        return this.md5Key;
    }

    public void setMd5Key(String md5Key) {
        this.md5Key = md5Key;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOrderQuery() {
        return this.orderQuery;
    }

    public void setOrderQuery(String orderQuery) {
        this.orderQuery = orderQuery;
    }

    public String getBalanceQuery() {
        return this.balanceQuery;
    }

    public void setBalanceQuery(String balanceQuery) {
        this.balanceQuery = balanceQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        StringReader xmlReader = new StringReader(body);
        InputSource xmlSource = new InputSource(xmlReader);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlSource);
        Element root = doc.getRootElement();
        String retcode = root.getChild("retcode").getValue();
        if ((root.getChild("err_msg").getValue() == null || root.getChild("err_msg").getValue().trim().length() == 0) && "1".equals(retcode)) {
            String spOrderId = root.getChild("orderid").getValue();
            String game_state = root.getChild("game_state").getValue();
            if ("1".equals(game_state)) {
                resp.setSuccess(true);
                resp.setSupplierBizId(spOrderId);
            } else if ("0".equals(game_state)) {
                resp.setSupplierBizId(spOrderId);
            } else if ("9".equals(game_state)) {
                resp.setSupplierBizId(spOrderId);
                resp.setError4Admin("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25,\u8ba2\u5355\u64a4\u9500\uff0c\u53ef\u9000\u6b3e\u3002");
                resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            } else {
                resp.setError4Admin("\u6b27\u98de\u8fd4\u56de\u72b6\u6001\u7801game_state\u4e3a\u672a\u77e5\u5904\u7406\u7c7b\u578b\uff1a" + game_state);
                resp.setError4Developer("\u4f9b\u5e94\u5546\u5145\u503c\u5931\u8d25");
                resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        } else if ("105".equals(retcode) || "334".equals(retcode) || "1043".equals(retcode) || "999".equals(retcode)) {
            SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
            so4u.setStatus("send");
            so4u.setErrorMessage("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u9700\u8c03\u67e5\u8be2\u63a5\u53e3\u786e\u8ba4\u8ba2\u5355\u72b6\u6001");
            so4u.setSupplierInfo(body);
            this.supplierOrdersService.update(so4u);
        } else {
            resp.setError4Admin("\u4e0a\u6e38\u7279\u6b8a\u5f02\u5e38\uff0c\u8fd4\u56de\u53c2\u6570\u5f02\u5e38");
            resp.setError4Developer("\u4e0a\u6e38\u5145\u503c\u5f02\u5e38");
            resp.setError4Consumer("\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so = this.supplierOrdersService.find(Long.valueOf(resp.getSupplierOrderId()));
        if ("create".equals(so.getStatus())) {
            so.setStatus("send");
        }
        so.setSendTime(new Date());
        SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
        so4u.setSendTime(so.getSendTime());
        so4u.setStatus(so.getStatus());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static class OufeiPhoneflowResponse
    extends BaseSupplierExchangeResponse {
    }

    public static class OufeiPhoneflowRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto supplierProduct;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.supplierProduct;
        }

        public void setSupplierProduct(SupplierProductDto supplierProduct) {
            this.supplierProduct = supplierProduct;
        }
    }
}

