/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.supplier.impl;

import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.phone_bill.PhoneAttributionDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.api.dto.unique_check.UniqueSupplierCheckDto;
import cn.com.duiba.order.center.biz.bo.PhoneAttributionBo;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierExchangeResponse;
import cn.com.duiba.order.center.biz.service.exchange.supplier.BaseSupplierOrderStatus;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierFailException;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.BaseSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.SupplierRequest;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import cn.com.duiba.order.center.biz.service.unique_check.UniqueSupplierCheckService;
import cn.com.duiba.order.center.biz.tool.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SududaPhonebillSupplier2
extends BaseSupplier2 {
    private static Logger logger = LoggerFactory.getLogger(SududaPhonebillSupplier2.class);
    private String apiUrl;
    private String username;
    private String secret;
    @Autowired
    private PhoneAttributionBo phoneAttributionBo;
    @Autowired
    private UniqueSupplierCheckService uniqueSupplierCheckService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;

    public static SupplierData.SupplierExchangeRequest buildRequest(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public SupplierData.SupplierExchangeResponse submit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId) throws SupplierFailException, Exception {
        PhoneAttributionDto pa;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-sududa")) {
            throw new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u901f\u5ea6\u8fbe\u8bdd\u8d39\u5145\u503c\u8ba2\u5355");
        }
        BaseSupplierExchangeResponse resp = new BaseSupplierExchangeResponse();
        String api = this.apiUrl;
        String prodId = sp.getProductId();
        String orderid = request.getOrderNum();
        String mobilenum = order.getBizParams().split(":")[0];
        String area = sp.getExtra();
        if ("0".equals(area.trim()) && (pa = this.phoneAttributionBo.findByPhone(mobilenum)) != null) {
            area = SududaPhonebillSupplier2.toProvinceInt(pa.getProvince()) + "";
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("username", this.username);
        para.put("power", "16");
        para.put("orderid", orderid);
        para.put("productid", prodId);
        para.put("to", mobilenum);
        para.put("count", "1");
        para.put("area", area);
        para.put("timestamp", (int)(System.currentTimeMillis() / 1000L) + "");
        para.put("ver", "3");
        para.put("format", "json");
        String urlTemp = "";
        urlTemp = Environment.isDaily() ? SududaPhonebillSupplier2.getRequestURL(api, "", para, this.secret) : SududaPhonebillSupplier2.getRequestURL(api, "api/recharge", para, this.secret);
        String url = urlTemp;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(url);
            get.setConfig(this.getTimeoutConfig());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            resp.setSupplierBody(body);
            JSONObject json = JSON.parseObject((String)body);
            String status = json.getJSONObject("sududa").getString("status");
            if ("1".equals(status)) {
                resp.setSuccess(true);
            } else if ("10".equals(status) || "-9".equals(status)) {
                String tips = json.getJSONObject("sududa").getString("tips");
                if (tips != null && tips.contains("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3")) {
                    resp.setError4Admin("\u5361\u5355:" + tips);
                    resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                    resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                } else if (tips != null && tips.contains("\u5e93\u5b58\u4e0d\u8db3")) {
                    resp.setError4Admin("\u5361\u5355:" + tips);
                    resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                    resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                } else {
                    resp.setFail(true);
                    resp.setError4Admin("\u4f9b\u5e94\u5546\u7aef\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25:" + json.getJSONObject("sududa").getString("tips") + "(" + status + ")");
                    resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                    resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            }
        }
        finally {
            so.setStatus("send");
            so.setSendTime(new Date());
            SupplierOrderDto so4u = new SupplierOrderDto(so.getId());
            so4u.setStatus(so.getStatus());
            so4u.setSendTime(so.getSendTime());
            this.supplierOrdersService.update(so4u);
            if (this.isHttpLogEnable()) {
                HttpRequestLogDto log = new HttpRequestLogDto(true);
                log.setType("ToSupplier");
                log.setTag(this.getSupplierName());
                log.setResp(resp.getSupplierBody());
                log.setAppId(order.getAppId());
                log.setOrderId(order.getId());
                log.setConsumerId(order.getConsumerId());
                log.setDeveloperId(order.getDeveloperId());
                log.setUrl(url);
                log.setGmtCreate(new Date());
                log.setGmtModified(new Date());
                if (log.getResp() != null) {
                    log.setSuccess(Boolean.valueOf(true));
                }
                StatHttpRequestLog.log(log);
            }
        }
        return resp;
    }

    @Override
    public void asyncSubmit(SupplierData.SupplierExchangeRequest request, Long orderId, Long consumerId, final Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if (!sp.getSupplier().equals("phonebill-sududa")) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u6b64\u8ba2\u5355\u4e0d\u662f\u901f\u5ea6\u8fbe\u8bdd\u8d39\u5145\u503c\u8ba2\u5355"));
                }
            });
            return;
        }
        UniqueSupplierCheckDto supplierCheck = new UniqueSupplierCheckDto(true);
        supplierCheck.setOrderNum(order.getOrderNum());
        supplierCheck.setSupplierOrderNum(so.getDuibaOrderNum());
        supplierCheck.setSupplier(sp.getSupplier());
        supplierCheck.setType(order.getType());
        try {
            this.uniqueSupplierCheckService.insert(supplierCheck);
        }
        catch (Exception e) {
            logger.error("\u5411\u4e0a\u6e38\u91cd\u590d\u8bf7\u6c42:orderNum=" + order.getOrderNum() + " ,supplierOrderNum=" + so.getDuibaOrderNum() + " ,error:" + e.getMessage());
            return;
        }
        String api = this.apiUrl;
        String prodId = sp.getProductId();
        String orderid = request.getOrderNum();
        String mobilenum = order.getBizParams().split(":")[0];
        String area = sp.getExtra();
        try {
            PhoneAttributionDto pa;
            if ("0".equals(area.trim()) && (pa = this.phoneAttributionBo.findByPhone(mobilenum)) != null) {
                area = SududaPhonebillSupplier2.toProvinceInt(pa.getProvince()) + "";
            }
        }
        catch (Exception e) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onException(new Exception("\u8ba2\u5355\u67e5\u8be2\u5730\u533a\u5931\u8d25", e));
                }
            });
            return;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("username", this.username);
        para.put("power", "16");
        para.put("orderid", orderid);
        para.put("productid", prodId);
        para.put("to", mobilenum);
        para.put("count", "1");
        para.put("area", area);
        para.put("timestamp", (int)(System.currentTimeMillis() / 1000L) + "");
        para.put("ver", "3");
        para.put("format", "json");
        String urlTemp = "";
        try {
            urlTemp = Environment.isDaily() ? SududaPhonebillSupplier2.getRequestURL(api, "", para, this.secret) : SududaPhonebillSupplier2.getRequestURL(api, "api/recharge", para, this.secret);
        }
        catch (Exception e1) {
            callback.onException(e1);
        }
        String url = urlTemp;
        SupplierRequest srequest = new SupplierRequest();
        srequest.setHttpUrl(url);
        srequest.setAppId(String.valueOf(order.getAppId()));
        srequest.setConsumerId(String.valueOf(order.getConsumerId()));
        srequest.setOrderId(String.valueOf(order.getId()));
        srequest.setSupplierOrderId(String.valueOf(order.getSupplierOrderId()));
        srequest.setSupplierName("phonebill-sududa");
        try {
            this.messageService.sendMsg(this.topicConstant.getPhonebillRequest(), JSONObject.toJSONString((Object)srequest));
        }
        catch (Exception e) {
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            logger.error("SupplierPhonebillSududa sendMsg:", (Throwable)e);
        }
    }

    public static SupplierData.SupplierExchangeRequest buildRequestData(SupplierProductDto sp, String orderNum) {
        PhonebillExchangeRequest req = new PhonebillExchangeRequest();
        req.setOrderNum(orderNum);
        req.setSupplierProduct(sp);
        return req;
    }

    @Override
    public SupplierData.SupplierOrderStatus queryOrderStatus(String orderNum, String supplierOrderId) throws Exception {
        BaseSupplierOrderStatus status = new BaseSupplierOrderStatus();
        String api = this.apiUrl;
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("username", this.username);
        para.put("timestamp", (int)(System.currentTimeMillis() / 1000L) + "");
        para.put("ver", "3");
        para.put("orderid", orderNum);
        para.put("format", "json");
        String url = SududaPhonebillSupplier2.getRequestURL(api, "api/status", para, "");
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost get = new HttpPost(url);
        get.setConfig(this.getTimeoutConfig());
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject json = JSON.parseObject((String)body);
        status.setResponse(body);
        String returnStatus = json.getJSONObject("sududa").getString("status");
        if (returnStatus.equals("1")) {
            status.setSuccess(true);
        } else if (returnStatus.equals("-9") || returnStatus.equals("10")) {
            status.setFail(true);
        } else {
            status.setProcessing(true);
        }
        return status;
    }

    @Override
    public BigDecimal queryBalance() throws Exception {
        String api = this.apiUrl;
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("username", this.username);
        para.put("timestamp", (int)(System.currentTimeMillis() / 1000L) + "");
        para.put("ver", "3");
        para.put("format", "json");
        String url = "";
        url = Environment.isDaily() ? SududaPhonebillSupplier2.getRequestURL(api + "QueryBalance", "", para, this.secret) : SududaPhonebillSupplier2.getRequestURL(api, "api/userinfo", para, this.secret);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost get = new HttpPost(url);
        CloseableHttpResponse response = null;
        response = client.execute((HttpUriRequest)get);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject json = JSON.parseObject((String)body);
        if ("1".equals(json.getJSONObject("sududa").getString("status"))) {
            return new BigDecimal(json.getJSONObject("sududa").getString("balance"));
        }
        throw new Exception(body);
    }

    @Override
    public SupplierData.SupplierOrderStatus callbackParse(HttpServletRequest request) throws Exception {
        BaseSupplierOrderStatus ret = new BaseSupplierOrderStatus();
        String orderNum = request.getParameter("orderNum");
        String status = request.getParameter("status");
        OrdersDto order = null;
        SupplierOrderDto so = null;
        if (orderNum.startsWith("duiba")) {
            so = this.supplierOrdersService.findByDuibaOrderNum(orderNum);
        } else {
            order = this.orderReadManagerBo.findByOrderNum(orderNum);
            so = this.supplierOrdersService.find(order.getSupplierOrderId());
        }
        SupplierProductDto sp = this.supplierProductsService.find(so.getSupplierProductId());
        if ("phonebill-sududa".equals(sp.getSupplier())) {
            if ("-9".equals(status) || "10".equals(status)) {
                ret.setFail(true);
            } else if ("1".equals(status)) {
                ret.setSuccess(true);
            }
        }
        return ret;
    }

    @Override
    public String getSupplierName() {
        return "sudoda";
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public static int toProvinceInt(String province) {
        if (province.contains("\u5317\u4eac")) {
            return 11;
        }
        if (province.contains("\u5929\u6d25")) {
            return 12;
        }
        if (province.contains("\u6cb3\u5317")) {
            return 13;
        }
        if (province.contains("\u5c71\u897f")) {
            return 14;
        }
        if (province.contains("\u5185\u8499")) {
            return 15;
        }
        if (province.contains("\u8fbd\u5b81")) {
            return 21;
        }
        if (province.contains("\u5409\u6797")) {
            return 22;
        }
        if (province.contains("\u9ed1\u9f99\u6c5f")) {
            return 23;
        }
        if (province.contains("\u4e0a\u6d77")) {
            return 31;
        }
        if (province.contains("\u6c5f\u82cf")) {
            return 32;
        }
        if (province.contains("\u6d59\u6c5f")) {
            return 33;
        }
        if (province.contains("\u5b89\u5fbd")) {
            return 34;
        }
        if (province.contains("\u798f\u5efa")) {
            return 35;
        }
        if (province.contains("\u6c5f\u897f")) {
            return 36;
        }
        if (province.contains("\u5c71\u4e1c")) {
            return 37;
        }
        if (province.contains("\u6cb3\u5357")) {
            return 41;
        }
        if (province.contains("\u6e56\u5317")) {
            return 42;
        }
        if (province.contains("\u6e56\u5357")) {
            return 43;
        }
        if (province.contains("\u5e7f\u4e1c")) {
            return 44;
        }
        if (province.contains("\u5e7f\u897f")) {
            return 45;
        }
        if (province.contains("\u6d77\u5357")) {
            return 46;
        }
        if (province.contains("\u91cd\u5e86")) {
            return 50;
        }
        if (province.contains("\u56db\u5ddd")) {
            return 51;
        }
        if (province.contains("\u8d35\u5dde")) {
            return 52;
        }
        if (province.contains("\u4e91\u5357")) {
            return 53;
        }
        if (province.contains("\u897f\u85cf")) {
            return 54;
        }
        if (province.contains("\u9655\u897f")) {
            return 61;
        }
        if (province.contains("\u7518\u8083")) {
            return 62;
        }
        if (province.contains("\u9752\u6d77")) {
            return 63;
        }
        if (province.contains("\u5b81\u590f")) {
            return 64;
        }
        if (province.contains("\u65b0\u7586")) {
            return 65;
        }
        return 0;
    }

    public static String toProvinceName(String value) {
        if ("0".equals(value.trim())) {
            return "\u5168\u56fd";
        }
        if ("11".equals(value.trim())) {
            return "\u5317\u4eac";
        }
        if ("12".equals(value.trim())) {
            return "\u5929\u6d25";
        }
        if ("13".equals(value.trim())) {
            return "\u6cb3\u5317";
        }
        if ("14".equals(value.trim())) {
            return "\u5c71\u897f";
        }
        if ("15".equals(value.trim())) {
            return "\u5185\u8499";
        }
        if ("21".equals(value.trim())) {
            return "\u8fbd\u5b81";
        }
        if ("22".equals(value.trim())) {
            return "\u5409\u6797";
        }
        if ("23".equals(value.trim())) {
            return "\u9ed1\u9f99\u6c5f";
        }
        if ("31".equals(value.trim())) {
            return "\u4e0a\u6d77";
        }
        if ("32".equals(value.trim())) {
            return "\u6c5f\u82cf";
        }
        if ("33".equals(value.trim())) {
            return "\u6d59\u6c5f";
        }
        if ("34".equals(value.trim())) {
            return "\u5b89\u5fbd";
        }
        if ("35".equals(value.trim())) {
            return "\u798f\u5efa";
        }
        if ("36".equals(value.trim())) {
            return "\u6c5f\u897f";
        }
        if ("37".equals(value.trim())) {
            return "\u5c71\u4e1c";
        }
        if ("41".equals(value.trim())) {
            return "\u6cb3\u5357";
        }
        if ("42".equals(value.trim())) {
            return "\u6e56\u5317";
        }
        if ("43".equals(value.trim())) {
            return "\u6e56\u5357";
        }
        if ("44".equals(value.trim())) {
            return "\u5e7f\u4e1c";
        }
        if ("45".equals(value.trim())) {
            return "\u5e7f\u897f";
        }
        if ("46".equals(value.trim())) {
            return "\u6d77\u5357";
        }
        if ("50".equals(value.trim())) {
            return "\u91cd\u5e86";
        }
        if ("51".equals(value.trim())) {
            return "\u56db\u5ddd";
        }
        if ("52".equals(value.trim())) {
            return "\u8d35\u5dde";
        }
        if ("53".equals(value.trim())) {
            return "\u4e91\u5357";
        }
        if ("54".equals(value.trim())) {
            return "\u897f\u85cf";
        }
        if ("61".equals(value.trim())) {
            return "\u9655\u897f";
        }
        if ("62".equals(value.trim())) {
            return "\u7518\u8083";
        }
        if ("63".equals(value.trim())) {
            return "\u9752\u6d77";
        }
        if ("64".equals(value.trim())) {
            return "\u5b81\u590f";
        }
        if ("65".equals(value.trim())) {
            return "\u65b0\u7586";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplierCallback(SupplierResponse response) {
        Long orderId = Long.valueOf(response.getOrderId());
        Long consumerId = Long.valueOf(response.getConsumerId());
        if (response.getCallbackType().equals("completed")) {
            Exception exception = null;
            try {
                this.successBlock(response);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.finallyBlock(response);
            }
            if (exception == null) {
                this.supplierExchangeFlowWorker.onFinish(orderId, consumerId, response);
            } else {
                this.supplierExchangeFlowWorker.onException(orderId, consumerId, exception);
            }
        } else if (response.getCallbackType().equals("failed")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception(response.getErrorMessage()));
        } else if (response.getCallbackType().equals("cancelled")) {
            this.finallyBlock(response);
            this.supplierExchangeFlowWorker.onException(orderId, consumerId, new Exception("\u8bf7\u6c42\u88ab\u53d6\u6d88"));
        }
    }

    private void successBlock(SupplierResponse resp) throws Exception {
        String body = resp.getBody();
        JSONObject json = JSON.parseObject((String)body);
        String status = json.getJSONObject("sududa").getString("status");
        if ("1".equals(status)) {
            resp.setSuccess(true);
        } else if ("10".equals(status) || "-9".equals(status)) {
            String tips = json.getJSONObject("sududa").getString("tips");
            if (tips != null && tips.contains("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3")) {
                resp.setError4Admin("\u5361\u5355:" + tips);
                resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            } else if (tips != null && tips.contains("\u5e93\u5b58\u4e0d\u8db3")) {
                resp.setError4Admin("\u5361\u5355:" + tips);
                resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            } else {
                resp.setFail(true);
                resp.setError4Admin("\u4f9b\u5e94\u5546\u7aef\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25:" + json.getJSONObject("sududa").getString("tips") + "(" + status + ")");
                resp.setError4Developer("\u5151\u6362\u5931\u8d25");
                resp.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
    }

    private void finallyBlock(SupplierResponse resp) {
        SupplierOrderDto so4u = new SupplierOrderDto(Long.valueOf(resp.getSupplierOrderId()));
        so4u.setStatus("send");
        so4u.setSendTime(new Date());
        this.supplierOrdersService.update(so4u);
        if (this.isHttpLogEnable()) {
            HttpRequestLogDto log = new HttpRequestLogDto(true);
            log.setType("ToSupplier");
            log.setTag(this.getSupplierName());
            log.setAppId(Long.valueOf(resp.getAppId()));
            log.setOrderId(Long.valueOf(resp.getOrderId()));
            log.setResp(resp.getBody());
            log.setConsumerId(Long.valueOf(resp.getConsumerId()));
            log.setUrl(resp.getUrl());
            log.setResp(resp.getBody());
            StatHttpRequestLog.log(log);
        }
    }

    public static String getRequestURL(String url, String path, Map<String, String> para, String key) throws Exception {
        String param = "";
        String signType = "";
        if (path.indexOf("/") != 0) {
            path = "/" + path;
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(para.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().toString().compareTo(o2.getKey());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry m = (Map.Entry)list.get(i);
            String k = (String)m.getKey();
            param = param + k + "=" + (String)m.getValue() + "&";
        }
        param = path + "?" + param;
        url = url + param;
        if (!"".equals(key) && key != null) {
            param = param + key;
            signType = "signkey";
        } else {
            param = param.substring(0, param.length() - 1);
            signType = "sign";
        }
        String sign = MD5.md5(URLEncoder.encode(param, "UTF-8"));
        url = url + signType + "=" + sign;
        return url;
    }

    public static class PhonebillExchangeRequest
    implements SupplierData.SupplierExchangeRequest {
        private SupplierProductDto sp;
        private String orderNum;

        @Override
        public String getOrderNum() {
            return this.orderNum;
        }

        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }

        public SupplierProductDto getSupplierProduct() {
            return this.sp;
        }

        public void setSupplierProduct(SupplierProductDto sp) {
            this.sp = sp;
        }
    }
}

