/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.exchange2.tool;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.activity.center.api.remoteservice.manual.RemoteManualOrderLotteryService;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.order.center.api.dto.log.HttpRequestLogDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.orders_extra.OrdersExtraDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.constant.Environment;
import cn.com.duiba.order.center.biz.dao.unique_check.UniqueOrderCheckDao;
import cn.com.duiba.order.center.biz.entity.unique_check.UniqueOrderCheckEntity;
import cn.com.duiba.order.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.order.center.biz.service.exchange.tool.ThreadPoolConsumeCreditsService;
import cn.com.duiba.order.center.biz.service.exchange.tool.ThreadPoolLotteryService;
import cn.com.duiba.order.center.biz.service.exchange2.tool.AssembleTool;
import cn.com.duiba.order.center.biz.service.exchange2.tool.ConsumeCreditsCallback;
import cn.com.duiba.order.center.biz.service.log.ConsumeCreditsLog;
import cn.com.duiba.order.center.biz.service.log.QueryCreditsLog;
import cn.com.duiba.order.center.biz.service.log.StatHttpRequestLog;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders_extra.OrdersExtraService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ToDeveloperTool2 {
    protected Logger log = LoggerFactory.getLogger(ToDeveloperTool2.class);
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    @Autowired
    protected RemoteConsumerService remoteConsumerService;
    @Autowired
    protected UniqueOrderCheckDao uniqueOrderCheckDAO;
    @Autowired
    protected OrdersTextChangeService ordersTextChangeService;
    @Autowired
    protected OrdersExtraService ordersExtraService;
    @Autowired
    protected RemoteAppService remoteAppService;
    @Autowired
    protected RemoteManualOrderLotteryService remoteManualOrderLotteryService;
    @Autowired
    protected RemoteAppItemService remoteAppItemService;
    @Autowired
    protected RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;

    public static JSONObject getOneDegreeJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (String key : o.keySet()) {
            if (o.get((Object)key) instanceof JSONObject) {
                JSONObject json2 = (JSONObject)o.get((Object)key);
                for (String key2 : json2.keySet()) {
                    json.put(key2, json2.get((Object)key2));
                }
                continue;
            }
            json.put(key, o.get((Object)key));
        }
        return json;
    }

    public Long queryCreditsAndUpdate(Long consumerId) throws Exception {
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        AppDO app = this.remoteAppService.find(consumer.getAppId());
        if (app.getCreditsRemainQueryUrl() == null) {
            throw new RuntimeException("\u6ca1\u6709\u586b\u5199\u67e5\u8be2\u5730\u5740");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", app.getAppKey());
        map.put("uid", consumer.getPartnerUserId());
        map.put("appSecret", app.getAppSecret());
        map.put("timestamp", new Date().getTime() + "");
        String sign = SignTool.sign(map);
        map.put("sign", sign);
        String queryUrl = app.getCreditsRemainQueryUrl();
        if (Environment.isDaily()) {
            if (app.getId() == 1L) {
                queryUrl = "http://114.215.202.163:9002/DeveloperApi/creditsQuery";
            } else if (app.getId() == 513L) {
                queryUrl = "http://114.215.202.163:9002/developerApi2/creditsQuery";
            } else if (app.getId() == 484L) {
                queryUrl = "http://114.215.202.163:9002/developerApi3/creditsQuery";
            } else if (app.getId() == 485L) {
                queryUrl = "http://114.215.202.163:9002/developerApi4/creditsQuery";
            }
        } else {
            queryUrl = "http://115.29.231.31:9001/DeveloperApi/creditsQuery";
        }
        String url = AssembleTool.assembleUrl(queryUrl, map);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)get);
        }
        catch (Exception e) {
            QueryCreditsLog.info("\u79ef\u5206\u67e5\u8be2\u5931\u8d25\uff0cappId=" + app.getId(), e);
            return null;
        }
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        JSONObject o = null;
        try {
            o = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            QueryCreditsLog.info("\u79ef\u5206\u67e5\u8be2\u7ed3\u679c\u89e3\u6790\u5931\u8d25\uff0cappId=" + app.getId(), e);
            return null;
        }
        if ("ok".equalsIgnoreCase(o.getString("status"))) {
            Long credits = o.getJSONObject("data").getLong("credits");
            this.remoteConsumerService.updateCredits(consumerId, credits);
            return credits;
        }
        throw new Exception(o.getString("errorMessage"));
    }

    public void asyncConsumeCredits(Long orderId, Long consumerId, final ConsumeCreditsCallback callback, ExecutorService es) {
        try {
            this.asyncConsumeCreditsInner(orderId, consumerId, callback, es);
        }
        catch (Exception e) {
            this.log.error("asyncConsumeCredits error", (Throwable)e);
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onFail(e);
                }
            });
        }
    }

    private void asyncConsumeCreditsInner(Long orderId, Long consumerId, final ConsumeCreditsCallback callback, final ExecutorService es) throws Exception {
        OrdersExtraDto oe;
        AppItemDO ai;
        final OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if ("api".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("turntable".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("singlelottery".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("hdtool".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("game".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("question".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if ("quizz".equals(order.getChargeMode())) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        if (order.getCredits() == 0L) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        final ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
        final AppDO app = this.remoteAppService.find(order.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(order.getCredits());
        p.setOrderNum(order.getOrderNum());
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType(order.getType());
        p.setIp(order.getIp());
        p.setFacePrice(order.getFacePrice());
        p.setActualPrice(order.getActualPrice());
        if ("wait".equals(order.getAuditStatus())) {
            p.setWaitAudit(true);
        }
        p.setDescription(order.getBrief());
        if (order.getAppItemId() != null && ("coupon".equals(order.getType()) || "object".equals(order.getType())) && StringUtils.isNotBlank((String)(ai = this.remoteAppItemService.find(order.getAppItemId())).getDevCustomCode())) {
            p.setItemCode(ai.getDevCustomCode());
        }
        if ((oe = this.ordersExtraService.findByOrderIdAndType(order.getId(), "orders")) != null && oe.getTransfer() != null) {
            p.setTransfer(oe.getTransfer());
        }
        if ("phonebill".equals(order.getType())) {
            p.setPhone(order.getBizParams().split(":")[0]);
            p.setParams(order.getBizParams().split(":")[0]);
        } else if ("qb".equals(order.getType())) {
            p.setQq(order.getBizParams().split(":")[0]);
            p.setParams(order.getBizParams().split(":")[0]);
        } else if ("phoneflow".equals(order.getType())) {
            p.setPhone(order.getBizParams().split(":")[0]);
            p.setParams(order.getBizParams().split(":")[0]);
        } else if ("alipaycode".equals(order.getType())) {
            p.setPhone(order.getBizParams().split(":")[0]);
        } else if ("alipayfast".equals(order.getType())) {
            p.setAlipay(order.getBizParams().split(":")[0]);
        } else if ("alipay".equals(order.getType())) {
            String[] s = order.getBizParams().split(":");
            String biz = s[0] + ":" + s[1];
            p.setAlipay(biz);
            p.setParams(biz);
        } else if ("virtual".equals(order.getType())) {
            p.setParams(order.getBizParams());
        } else if ("object".equals(order.getType())) {
            p.setParams(order.getBizParams());
        }
        Map map = p.toRequestMap(app.getAppSecret());
        if (app.getCreditsConsumeRequestUrl() == null) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    callback.onFail(new Exception("\u6263\u79ef\u5206\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            });
            return;
        }
        final String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
        Object request = "baiduyun".equals(Environment.getPlace()) ? AssembleTool.assembleRequest(app.getCreditsConsumeRequestUrl(), map) : new HttpGet(url);
        ThreadPoolConsumeCreditsService.get().submit(order.getAppId(), (HttpUriRequest)request, new FutureCallback<HttpResponse>(){

            public void cancelled() {
                ConsumeCreditsLog.info("request url:" + url);
                ConsumeCreditsLog.info("\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u8bf7\u6c42\u88ab\u53d6\u6d88");
                final DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u8bf7\u6c42\u88ab\u53d6\u6d88");
                exc.setUrl(url);
                exc.setFailType(1);
                exc.setNormalFail(false);
                exc.setInterfaceType(1);
                this.finallyBlock(null, exc);
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail(exc);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                String body = null;
                Exception exception = null;
                try {
                    body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                    this.successBlock(response, body);
                }
                catch (Exception e) {
                    exception = e;
                    if (!(e instanceof DeveloperConsumeFailedException)) {
                        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
                        exc.setUrl(url);
                        exc.setDevRespone(e.getMessage());
                        exc.setFailType(1);
                        exc.setNormalFail(false);
                        exc.setInterfaceType(1);
                        exception = exc;
                    }
                }
                finally {
                    this.finallyBlock(body, exception);
                }
                final Exception finallyE = exception;
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (finallyE == null) {
                            callback.onSuccess();
                        } else {
                            callback.onFail(finallyE);
                        }
                    }
                });
            }

            public void failed(Exception e) {
                ConsumeCreditsLog.info("request url:" + url, e);
                ConsumeCreditsLog.info("\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519:", e);
                if (!(e instanceof DeveloperConsumeFailedException)) {
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
                    exc.setUrl(url);
                    exc.setDevRespone(e.getMessage());
                    exc.setFailType(1);
                    exc.setNormalFail(false);
                    exc.setInterfaceType(1);
                    e = exc;
                }
                this.finallyBlock(null, e);
                final Exception finallyE = e;
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail(finallyE);
                    }
                });
            }

            private void successBlock(HttpResponse response, String body) throws Exception {
                String bizId;
                JSONObject o = null;
                try {
                    o = JSON.parseObject((String)body);
                }
                catch (Exception e) {
                    ConsumeCreditsLog.info("request url:" + url);
                    ConsumeCreditsLog.info("resp body:" + body);
                    ConsumeCreditsLog.info("JSON\u89e3\u6790\u5931\u8d25", e);
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5f00\u53d1\u8005\u670d\u52a1\u5668\u54cd\u5e94\u5185\u5bb9JSON\u89e3\u6790\u5931\u8d25");
                    exc.setUrl(url);
                    exc.setDevRespone(body);
                    exc.setFailType(3);
                    exc.setNormalFail(false);
                    exc.setInterfaceType(1);
                    throw exc;
                }
                if (o == null) {
                    throw new Exception("\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
                }
                JSONObject json = ToDeveloperTool2.getOneDegreeJson(o);
                if ("ok".equalsIgnoreCase(json.getString("status"))) {
                    Long credits = json.getLong("credits");
                    if (credits != null && credits >= 0L) {
                        ToDeveloperTool2.this.remoteConsumerService.updateCredits(consumer.getId(), credits);
                    }
                    bizId = json.getString("bizId");
                    UniqueOrderCheckEntity uoc = new UniqueOrderCheckEntity(true);
                    uoc.setAppId(app.getId());
                    uoc.setDeveloperBizId(bizId);
                    uoc.setSource("mall");
                    try {
                        ToDeveloperTool2.this.uniqueOrderCheckDAO.insert(uoc);
                    }
                    catch (Exception e) {
                        ToDeveloperTool2.this.log.error("\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u91cd\u590d\uff0cAPP=" + app.getId() + "\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u4e3a\uff1a" + bizId, (Object)e.getMessage());
                        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u4e0d\u80fd\u91cd\u590d");
                        exc.setUrl(url);
                        exc.setDevRespone(body);
                        exc.setFailType(2);
                        exc.setNormalFail(false);
                        exc.setInterfaceType(1);
                        throw exc;
                    }
                } else {
                    DeveloperConsumeFailedException dcf = new DeveloperConsumeFailedException("", json.getString("errorMessage"));
                    dcf.setNormalFail(true);
                    throw dcf;
                }
                OrdersDto o4u = new OrdersDto(order.getId());
                o4u.setDeveloperBizId(bizId);
                ToDeveloperTool2.this.ordersTextChangeService.updateDevelopBizId(o4u.getId(), consumer.getId(), o4u.getDeveloperBizId());
            }

            private void finallyBlock(String body, Exception e) {
                HttpRequestLogDto hrl = new HttpRequestLogDto(true);
                hrl.setUrl(url);
                hrl.setType("ToDeveloper");
                hrl.setTag("consume");
                hrl.setOrderId(order.getId());
                hrl.setConsumerId(order.getConsumerId());
                hrl.setAppId(order.getAppId());
                if (e == null) {
                    hrl.setSuccess(Boolean.valueOf(true));
                } else {
                    hrl.setSuccess(Boolean.valueOf(false));
                }
                hrl.setResp(body);
                StatHttpRequestLog.log(hrl);
            }
        });
    }

    public void asyncManualLotteryConsumeCredits(Long manualLotteryOrderId, ConsumeCreditsCallback callback) {
        try {
            this.asyncManualLotteryConsumeCreditsInner(manualLotteryOrderId, callback);
        }
        catch (Exception e) {
            this.log.error("asyncManualLotteryConsumeCredits error", (Throwable)e);
            callback.onFail(e);
        }
    }

    private void asyncManualLotteryConsumeCreditsInner(Long manualLotteryOrderId, final ConsumeCreditsCallback callback) throws Exception {
        final ManualLotteryOrderDto manualLotteryOrder = this.remoteManualOrderLotteryService.find(manualLotteryOrderId);
        if (manualLotteryOrder.getCredits() == 0L) {
            ThreadPoolLotteryService.get().submit(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess();
                }
            });
            return;
        }
        final ConsumerDO consumer = this.remoteConsumerService.find(manualLotteryOrder.getConsumerId());
        final AppDO app = this.remoteAppService.find(manualLotteryOrder.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(manualLotteryOrder.getCredits());
        p.setOrderNum(ManualLotteryOrderDto.generateOrderNum((Long)manualLotteryOrderId));
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType("manualLottery");
        p.setIp(manualLotteryOrder.getIp());
        p.setFacePrice(Integer.valueOf(0));
        p.setActualPrice(Integer.valueOf(0));
        OperatingActivityDto oa = this.remoteOperatingActivityServiceNew.find(manualLotteryOrder.getOperatingActivityId());
        p.setDescription("\u624b\u52a8\u5f00\u5956," + oa.getTitle());
        OrdersExtraDto oe = this.ordersExtraService.findByOrderIdAndType(manualLotteryOrderId, "manuallottery");
        if (oe != null && oe.getTransfer() != null) {
            p.setTransfer(oe.getTransfer());
        }
        Map map = p.toRequestMap(app.getAppSecret());
        final String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
        Object request = "baiduyun".equals(Environment.getPlace()) ? AssembleTool.assembleRequest(app.getCreditsConsumeRequestUrl(), map) : new HttpGet(url);
        ThreadPoolConsumeCreditsService.get().submit(manualLotteryOrder.getAppId(), (HttpUriRequest)request, new FutureCallback<HttpResponse>(){

            public void cancelled() {
                ConsumeCreditsLog.info("request url:" + url);
                ConsumeCreditsLog.info("\u8bf7\u6c42\u88ab\u53d6\u6d88");
                final DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u8bf7\u6c42\u88ab\u53d6\u6d88");
                exc.setUrl(url);
                exc.setFailType(1);
                exc.setNormalFail(false);
                exc.setInterfaceType(1);
                this.finallyBlock(null, exc);
                ThreadPoolLotteryService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail(exc);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                String body = null;
                Exception exception = null;
                try {
                    body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                    this.successBlock(body);
                }
                catch (Exception e) {
                    exception = e;
                    if (!(e instanceof DeveloperConsumeFailedException)) {
                        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
                        exc.setUrl(url);
                        exc.setDevRespone(e.getMessage());
                        exc.setFailType(1);
                        exc.setNormalFail(false);
                        exc.setInterfaceType(1);
                        exception = exc;
                    }
                }
                finally {
                    this.finallyBlock(body, exception);
                }
                final Exception finallyE = exception;
                ThreadPoolLotteryService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        if (finallyE == null) {
                            callback.onSuccess();
                        } else {
                            callback.onFail(finallyE);
                        }
                    }
                });
            }

            public void failed(Exception e) {
                ConsumeCreditsLog.info("request url:" + url, e);
                ConsumeCreditsLog.info("\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519: appId=" + app.getId(), e);
                if (!(e instanceof DeveloperConsumeFailedException)) {
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5411\u5f00\u53d1\u8005\u8bf7\u6c42\u6263\u79ef\u5206\uff0c\u7f51\u7edc\u8bf7\u6c42\u51fa\u9519");
                    exc.setUrl(url);
                    exc.setDevRespone(e.getMessage());
                    exc.setFailType(1);
                    exc.setNormalFail(false);
                    exc.setInterfaceType(1);
                    e = exc;
                }
                this.finallyBlock(null, e);
                final Exception finallyE = e;
                ThreadPoolLotteryService.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFail(finallyE);
                    }
                });
            }

            private void successBlock(String body) throws Exception {
                String bizId;
                JSONObject o = null;
                try {
                    o = JSON.parseObject((String)body);
                }
                catch (Exception e) {
                    ConsumeCreditsLog.info("request url:" + url);
                    ConsumeCreditsLog.info("resp body:" + body);
                    ConsumeCreditsLog.info("JSON\u89e3\u6790\u5931\u8d25", e);
                    DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u5f00\u53d1\u8005\u670d\u52a1\u5668\u54cd\u5e94\u5185\u5bb9JSON\u89e3\u6790\u5931\u8d25");
                    exc.setUrl(url);
                    exc.setDevRespone(body);
                    exc.setFailType(3);
                    exc.setNormalFail(false);
                    exc.setInterfaceType(1);
                    throw exc;
                }
                if (o == null) {
                    throw new Exception("\u670d\u52a1\u5668\u5f02\u5e38");
                }
                JSONObject json = ToDeveloperTool2.getOneDegreeJson(o);
                if ("ok".equalsIgnoreCase(json.getString("status"))) {
                    Long credits = json.getLong("credits");
                    if (credits != null && credits >= 0L) {
                        ToDeveloperTool2.this.remoteConsumerService.updateCredits(consumer.getId(), credits);
                    }
                    bizId = json.getString("bizId");
                    UniqueOrderCheckEntity uoc = new UniqueOrderCheckEntity(true);
                    uoc.setAppId(app.getId());
                    uoc.setDeveloperBizId(bizId);
                    uoc.setSource("manuallottery");
                    try {
                        ToDeveloperTool2.this.uniqueOrderCheckDAO.insert(uoc);
                    }
                    catch (Exception e) {
                        ToDeveloperTool2.this.log.error("\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u91cd\u590d\uff0cAPP=" + app.getId() + "\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u4e3a\uff1a" + bizId, (Object)e.getMessage());
                        DeveloperConsumeFailedException exc = new DeveloperConsumeFailedException("", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u4e0d\u80fd\u91cd\u590d");
                        exc.setUrl(url);
                        exc.setDevRespone(body);
                        exc.setFailType(2);
                        exc.setNormalFail(false);
                        exc.setInterfaceType(1);
                        throw exc;
                    }
                } else {
                    DeveloperConsumeFailedException dcf = new DeveloperConsumeFailedException("", json.getString("errorMessage"));
                    dcf.setNormalFail(true);
                    throw dcf;
                }
                ManualLotteryOrderDto o4u = new ManualLotteryOrderDto(manualLotteryOrder.getId());
                o4u.setDeveloperBizId(bizId);
                o4u.setGmtModified(new Date());
                ToDeveloperTool2.this.remoteManualOrderLotteryService.update(o4u);
            }

            private void finallyBlock(String body, Exception e) {
                HttpRequestLogDto hrl = new HttpRequestLogDto(true);
                hrl.setUrl(url);
                hrl.setType("ToDeveloper");
                hrl.setTag("consume");
                hrl.setTurntableOrderId(manualLotteryOrder.getId());
                hrl.setConsumerId(consumer.getId());
                hrl.setAppId(consumer.getAppId());
                hrl.setDeveloperId(app.getDeveloperId());
                if (e == null) {
                    hrl.setSuccess(Boolean.valueOf(true));
                } else {
                    hrl.setSuccess(Boolean.valueOf(false));
                }
                hrl.setResp(body);
                StatHttpRequestLog.log(hrl);
            }
        });
    }
}

