/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.consumer.impl;

import cn.com.duiba.order.center.biz.bo.OrderSyncBo;
import cn.com.duiba.order.center.biz.dao.orders.consumer.OrdersStatusChangeDao;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersStatusChangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersStatusChangeServiceImpl
implements OrdersStatusChangeService {
    @Autowired
    private OrderSyncBo orderSyncBo;
    @Autowired
    private OrdersStatusChangeDao ordersStatusChangeDao;

    @Override
    public int doAuditPass(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doAuditPass(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType) {
        int ret = this.ordersStatusChangeDao.doAuditReject(orderId, consumerId, error4consumer, error4developer, error4admin, failType);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus) throws Exception {
        int ret = this.ordersStatusChangeDao.doMakeSuccess(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice) throws Exception {
        int ret = this.ordersStatusChangeDao.doMakeFail(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus, consumerPaybackPrice);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doForceConsumeSuccess(Long orderId, Long consumerId, String error4admin) {
        int ret = this.ordersStatusChangeDao.doForceConsumeSuccess(orderId, consumerId, error4admin);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doMakeConsumeSuccess(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) {
        int ret = this.ordersStatusChangeDao.doMakeConsumeFail(orderId, consumerId, failType, error4consumer, error4developer, error4admin);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief) {
        int ret = this.ordersStatusChangeDao.doUpdateAllowInputUsed(orderId, consumerId, supplierOrderId, bizParams, brief);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, Long supplierOrderId, String bizParams) {
        int ret = this.ordersStatusChangeDao.doUpdateAllowInputUsed4Object(orderId, consumerId, supplierOrderId, bizParams);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus) {
        int ret = this.ordersStatusChangeDao.updatePayOrderStatus(orderId, consumerId, payStatus);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus) {
        int ret = this.ordersStatusChangeDao.updateDuibaPayOrderStatus(orderId, consumerId, duibaPayStatus);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doDeleteOrdersByOrderId(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doDeleteOrdersByOrderId(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doAmbConsumerPayStatusPaySuccess(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doAmbConsumerPayStatusPayBack(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doAmbConsumerPayStatusPayBack(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer doAmbStatusAfterSend(Long orderId, Long consumerId) {
        int ret = this.ordersStatusChangeDao.doAmbStatusAfterSend(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }
}

