/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.consumer.impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderSyncBo;
import cn.com.duiba.order.center.biz.dao.orders.consumer.OrdersTextChangeDao;
import cn.com.duiba.order.center.biz.entity.orders.OrdersEntity;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrdersTextChangeServiceImpl
implements OrdersTextChangeService {
    @Autowired
    private OrdersTextChangeDao ordersTextChangeDao;
    @Autowired
    private OrderSyncBo orderSyncBo;

    @Override
    public long getSequenceID() {
        return this.ordersTextChangeDao.getSequenceID();
    }

    @Override
    public void insert(OrdersDto order) throws Exception {
        OrdersEntity entity = (OrdersEntity)BeanUtils.copy((Object)order, OrdersEntity.class);
        this.ordersTextChangeDao.insert(entity);
        order.setId(entity.getId());
        this.orderSyncBo.sync(order.getId(), order.getConsumerId());
    }

    @Override
    public Integer updateAllowInputAndTips(Long orderId, Long consumerId, Boolean allowInput, String allowInputTips) {
        int ret = this.ordersTextChangeDao.updateAllowInputAndTips(orderId, consumerId, allowInput, allowInputTips);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage, String error4Consumer, String error4Develper, String error4Admin) {
        int ret = this.ordersTextChangeDao.updateErrorMessageAndFailType(orderId, consumerId, failType, errorMessage, error4Consumer, error4Develper, error4Admin);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public void releaseCouponByOrderId(Long orderId, Long consumerId) {
        this.ordersTextChangeDao.releaseCouponByOrderId(orderId, consumerId);
        this.orderSyncBo.sync(orderId, consumerId);
    }

    @Override
    public Integer updateSupplierOrderId(Long orderId, Long consumerId, Long supplierOrderId) {
        int ret = this.ordersTextChangeDao.updateSupplierOrderId(orderId, consumerId, supplierOrderId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updateDevelopBizId(Long orderId, Long consumerId, String developBizId) {
        int ret = this.ordersTextChangeDao.updateDevelopBizId(orderId, consumerId, developBizId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updateNotify(Long orderId, Long consumerId, Integer notify) {
        int ret = this.ordersTextChangeDao.updateNotify(orderId, consumerId, notify);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        int ret = this.ordersTextChangeDao.updateLastSendTime(orderId, consumerId, lastSendTime);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int updateErrorInfo(Long orderId, Long consumerId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.ordersTextChangeDao.updateErrorInfo(orderId, consumerId, error4admin, error4developer, error4consumer);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int updateSubOrderIdById(Long orderId, Long consumerId, Long subId) {
        int ret = this.ordersTextChangeDao.updateSubOrderIdById(orderId, consumerId, subId);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int updateConsumerPayBackPrice(Long orderId, Long consumerId, Long consumerPayBackPrice) {
        int ret = this.ordersTextChangeDao.updateConsumerPayBackPrice(orderId, consumerId, consumerPayBackPrice);
        this.orderSyncBo.sync(orderId, consumerId);
        return ret;
    }

    @Override
    public int updateCouponId(Long orderId, Long consumerId, Long couponId) {
        int ret = this.ordersTextChangeDao.updateCouponId(orderId, consumerId, couponId);
        return ret;
    }
}

