/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.service.amb.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowworkStatusChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AfterSendFlowWorker
extends BaseFlowWorker {
    private static Logger logger = LoggerFactory.getLogger(AfterSendFlowWorker.class);
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    protected FlowworkStatusChangeService flowworkStatusChangeService;

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, ExecutorService es) throws Exception {
        OrdersDto ordersDO = this.getOrder(orderId, consumerId);
        this.flowworkStatusChangeService.changeSupplierExchange2AfterSend(orderId, consumerId);
        if (ordersDO.getConsumerPayPrice() > 0L) {
            if ("object".equals(ordersDO.getType())) {
                return;
            }
            this.ambSubOrdersService.updateShipStatus4ReceivedAtCreate(ordersDO.getSubOrderId());
            this.flowworkStatusChangeService.markAfterSendComplete(orderId, consumerId);
            es.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(orderId, consumerId);
                }
            });
        } else {
            this.flowworkStatusChangeService.markAfterSendComplete(orderId, consumerId);
            es.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(orderId, consumerId);
                }
            });
        }
    }

    public void receivedTimeout(Long orderId, Long consumerId) throws Exception {
        this.markAfterSend2Complete(orderId, consumerId);
    }

    public void dlpCompletePostsale(Long orderId, Long consumerId) throws Exception {
        this.markAfterSend2Complete(orderId, consumerId);
    }

    public void mngCompletePostsale(Long orderId, Long consumerId) throws Exception {
        this.markAfterSend2Complete(orderId, consumerId);
    }

    public void maxTimeTimeout(Long orderId, Long consumerId) throws Exception {
        this.markAfterSend2Complete(orderId, consumerId);
    }

    public void markAfterSend2Complete(Long orderId, Long consumerId) throws Exception {
        this.checkStayAtMyNode(orderId, consumerId);
        int ret = this.flowworkStatusChangeService.markAfterSendComplete(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u51fa\u9519\u4e86");
        }
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.AfterSend;
    }
}

