/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.service.email.PayCenterLog;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersStatusChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.master.MasterOrdersPayCenterExceptionService;
import cn.com.duiba.paycenter.client.PayOrdersServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.PayOrdersExtraParams;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeveloperPayFlowWorker
extends BaseFlowWorker {
    private static Logger logger = LoggerFactory.getLogger(DeveloperPayFlowWorker.class);
    @Autowired
    private PayOrdersServiceClient payOrdersServiceClient;
    @Autowired
    private MasterOrdersPayCenterExceptionService masterOrdersPayCenterExceptionService;
    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    private ExecutorService callpool = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private int i;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DeveloperPayFlowWorker-" + this.i++);
        }
    });

    public int dumpSize() {
        Integer activeThread = ((ThreadPoolExecutor)this.callpool).getActiveCount();
        return activeThread;
    }

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, final ExecutorService es) throws Exception {
        int ret = this.flowworkStatusChangeService.changeCreate2DeveloperPay(orderId, consumerId);
        if (ret == 1) {
            final OrdersDto order = this.getOrder(orderId, consumerId);
            if (order.getActualPrice() == 0 && "none".equals(order.getPayStatus())) {
                int complete = this.flowworkStatusChangeService.markDeveloperPayComplete(orderId, consumerId);
                if (complete == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(orderId, consumerId);
                        }
                    });
                }
            } else if (order.getActualPrice() > 0 && "wait_pay".equals(order.getPayStatus())) {
                this.callpool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DeveloperPayFlowWorker.this.callPayCenter(order, listener, es);
                        }
                        catch (Exception e) {
                            logger.error("call pay center ", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public void retryDeveloperPay(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        if (order.getActualPrice() > 0) {
            this.callPayCenter(order, this.flowworkEngine.getGoingListener(), this.flowworkEngine.getExecutorService());
        }
    }

    public void forceMakeFail(Long orderId, Long consumerId) throws Exception {
        this.flowworkStatusChangeService.changeDeveloperPay2Fail(orderId, consumerId);
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.DeveloperPay;
    }

    private void callPayCenter(final OrdersDto order, final CompleteListener listener, ExecutorService es) throws Exception {
        PayOrdersExtraParams pa = new PayOrdersExtraParams();
        pa.setAppId(order.getAppId());
        pa.setCredits(order.getCredits());
        pa.setMemo("\u8bf7\u6c42\u5b9a\u5355\u652f\u4ed8");
        RpcResult result = this.payOrdersServiceClient.payOrder(order.getDeveloperId(), order.getId(), Long.valueOf(order.getActualPrice().intValue()), pa);
        if (!result.isOpSuccess()) {
            PayCenterLog.error("call payOrdersServiceClient.payOrder  exception developId " + order.getDeveloperId(), (Throwable)result.getRpcException());
            for (int i = 0; i < OrdersDto.try_again_count; ++i) {
                Uninterruptibles.sleepUninterruptibly((long)OrdersDto.try_again_interval_time.intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                result = this.payOrdersServiceClient.payOrder(order.getDeveloperId(), order.getId(), Long.valueOf(order.getActualPrice().intValue()), pa);
                if (result.isOpSuccess()) break;
                PayCenterLog.error("call payOrdersServiceClient.payOrder  exception developId: " + order.getDeveloperId() + " try again " + i, (Throwable)result.getRpcException());
            }
            if (!result.isOpSuccess()) {
                this.masterOrdersPayCenterExceptionService.insert(order, "wait_pay  \u4e0b\u5355\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3 \u5c1d\u8bd5\u4e09\u6b21\u4e4b\u540e\u5907\u4efd");
                PayCenterLog.error("try again " + OrdersDto.try_again_count + " failed" + "  call payOrdersServiceClient.payOrder  exception developId:" + order.getDeveloperId() + "  money:  " + order.getActualPrice() + "  ordersID : " + order.getId(), (Throwable)result.getRpcException());
                throw new RuntimeException("\u548c\u652f\u4ed8\u4e2d\u5fc3\u4ea4\u4e92\u5f02\u5e38");
            }
        }
        if (result.isOpSuccess()) {
            if (!((PayOrdersResult)result.getResult()).isBizSuccess()) {
                PayCenterLog.error("call payOrdersServiceClient.payOrder  is final failed  developId: " + order.getDeveloperId(), ((PayOrdersResult)result.getResult()).getErrorException());
                this.masterOrdersPayCenterExceptionService.insert(order, "wait_pay  \u652f\u4ed8\u5931\u8d25  \u5907\u4efd");
                int ret = this.flowworkStatusChangeService.changeDeveloperPay2Fail(order.getId(), order.getConsumerId());
                if (ret == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(order.getId(), order.getConsumerId());
                        }
                    });
                }
            }
            if (((PayOrdersResult)result.getResult()).isBizSuccess()) {
                PayCenterLog.info("call payOrdersServiceClient.payOrder is successful set pay order status is prereduce");
                this.ordersStatusChangeService.updatePayOrderStatus(order.getId(), order.getConsumerId(), "prereduce");
                int complete = this.flowworkStatusChangeService.markDeveloperPayComplete(order.getId(), order.getConsumerId());
                if (complete == 1) {
                    es.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(order.getId(), order.getConsumerId());
                        }
                    });
                }
            }
        }
    }
}

