/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.FlowworkStage;
import cn.com.duiba.order.center.api.dto.flowwork.NodeSubStatus;
import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.utils.FlowworkTool;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersSimpleService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.FlowworkEngine;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.AfterSendFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.AuditFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.ConsumeCreditsFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.ConsumerPayFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.DeveloperPayFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.DuibaPayFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.FailFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SuccessFlowWorker;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.SupplierExchangeFlowWorker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowworkEngingImpl
implements FlowworkEngine {
    private static Logger log = LoggerFactory.getLogger(FlowworkEngingImpl.class);
    private List<NodeType> list = Collections.synchronizedList(Arrays.asList(NodeType.Create, NodeType.DeveloperPay, NodeType.DuibaPay, NodeType.ConsumeCredits, NodeType.ConsumerPay, NodeType.Audit, NodeType.SupplierExchange, NodeType.AfterSend, NodeType.Success));
    private Map<NodeType, FlowWorker> workerMap = new HashMap<NodeType, FlowWorker>();
    @Autowired
    private OrdersSimpleService ordersSimpleService;
    @Autowired
    private ConsumeCreditsFlowWorker consumeCreditsFlowWorker;
    @Autowired
    private ConsumerPayFlowWorker consumerPayFlowWorker;
    @Autowired
    private AuditFlowWorker auditFlowWorker;
    @Autowired
    private SupplierExchangeFlowWorker supplierExchangeFlowWorker;
    @Autowired
    private AfterSendFlowWorker afterSendFlowWorker;
    @Autowired
    private SuccessFlowWorker successFlowWorker;
    @Autowired
    private FailFlowWorker failFlowWorker;
    @Autowired
    private DeveloperPayFlowWorker developerPayFlowWorker;
    @Autowired
    private DuibaPayFlowWorker duibaPayFlowWorker;
    private ExecutorService es = Executors.newFixedThreadPool(100, new ThreadFactory(){
        private int i = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "FlowworkEngine-" + this.i++);
        }
    });
    private CompleteListener goingListener = new CompleteListener(){

        @Override
        public void onComplete(Long orderId, Long consumerId) {
            try {
                FlowworkEngingImpl.this.go(orderId, consumerId);
            }
            catch (Exception e) {
                log.error("go run error", (Throwable)e);
            }
        }
    };

    @Override
    public ExecutorService getExecutorService() {
        return this.es;
    }

    @Override
    public CompleteListener getGoingListener() {
        return this.goingListener;
    }

    @Override
    public void go(Long orderId, Long consumerId) throws Exception {
        OrdersDto order = this.ordersSimpleService.find(orderId, consumerId);
        FlowworkStage stage = FlowworkTool.getStage((OrdersDto)order);
        if (stage.nodeSubStatus == NodeSubStatus.Started) {
            throw new Exception("started \u72b6\u6001\u65e0\u6cd5\u6267\u884c");
        }
        if (stage.nodeSubStatus == NodeSubStatus.Complete) {
            NodeType nextNodeType = this.getNextNodeType(stage.nodeType);
            FlowWorker nextWorker = this.getFlowWorker(nextNodeType);
            if (nextWorker != null) {
                try {
                    nextWorker.asyncStart(orderId, consumerId, this.goingListener, this.es);
                }
                catch (Exception e) {
                    log.error("flowwork enging go error", (Throwable)e);
                    throw e;
                }
            }
        } else if (stage.nodeSubStatus == NodeSubStatus.Tofail) {
            this.failFlowWorker.asyncStart(orderId, consumerId, this.goingListener, this.es);
        }
    }

    private FlowWorker getFlowWorker(NodeType nodeType) {
        if (this.workerMap.isEmpty()) {
            this.workerMap.put(NodeType.DeveloperPay, this.developerPayFlowWorker);
            this.workerMap.put(NodeType.DuibaPay, this.duibaPayFlowWorker);
            this.workerMap.put(NodeType.ConsumeCredits, this.consumeCreditsFlowWorker);
            this.workerMap.put(NodeType.ConsumerPay, this.consumerPayFlowWorker);
            this.workerMap.put(NodeType.Audit, this.auditFlowWorker);
            this.workerMap.put(NodeType.SupplierExchange, this.supplierExchangeFlowWorker);
            this.workerMap.put(NodeType.AfterSend, this.afterSendFlowWorker);
            this.workerMap.put(NodeType.Success, this.successFlowWorker);
            this.workerMap.put(NodeType.Fail, this.failFlowWorker);
        }
        return this.workerMap.get(nodeType);
    }

    private NodeType getNextNodeType(NodeType nodeType) {
        int index = this.list.indexOf(nodeType);
        if (index < this.list.size() - 1) {
            return this.list.get(index + 1);
        }
        return null;
    }
}

