/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl;

import cn.com.duiba.order.center.api.dto.flowwork.NodeType;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.amb.AmbOrderFastBo;
import cn.com.duiba.order.center.biz.bo.amb.AmbSettledBo;
import cn.com.duiba.order.center.biz.core.event.DuibaEventsDispatcher;
import cn.com.duiba.order.center.biz.core.event.OrdersEvent;
import cn.com.duiba.order.center.biz.service.notify.NotifyQueueInsertService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.CompleteListener;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.BaseFlowWorker;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuccessFlowWorker
extends BaseFlowWorker {
    private static Logger logger = LoggerFactory.getLogger(SuccessFlowWorker.class);
    @Autowired
    private NotifyQueueInsertService notifyQueueInsertService;
    @Autowired
    private AmbOrderFastBo ambOrderFastBo;
    @Autowired
    private AmbSettledBo ambSettledBo;
    @Autowired
    private DuibaEventsDispatcher duibaEventsDispatcher;

    @Override
    public void asyncStart(final Long orderId, final Long consumerId, final CompleteListener listener, ExecutorService es) throws Exception {
        int ret = this.flowworkStatusChangeService.changeAfterSend2Success(orderId, consumerId);
        if (ret != 1) {
            throw new Exception("\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
        OrdersDto order = this.getOrder(orderId, consumerId);
        this.doWork(order);
        this.flowworkStatusChangeService.markSuccessComplete(orderId, consumerId);
        es.submit(new Runnable(){

            @Override
            public void run() {
                listener.onComplete(orderId, consumerId);
            }
        });
    }

    private void doWork(OrdersDto order) throws Exception {
        if ("success".equals(order.getStatus()) || "fail".equals(order.getStatus())) {
            throw new Exception("\u72b6\u6001\u9519\u8bef" + order.getStatus());
        }
        boolean success = false;
        success = this.ordersStatusChangeBo.doMakeSuccess(order.getId(), order.getConsumerId());
        if (!success) {
            throw new Exception("doMakeSuccess \u5931\u8d25");
        }
        if (order.getConsumerPayPrice() > 0L) {
            try {
                this.ambOrderFastBo.removeOrderFastAtFinish(order.getId());
                this.ambSettledBo.ambSettled(order.getId(), order.getConsumerId());
            }
            catch (Exception e) {
                logger.error("\u52a0\u94b1\u8d2d\u7ed3\u7b97\u51fa\u73b0\u5f02\u5e38    orderId=" + order.getId(), (Throwable)e);
            }
        }
        this.notifyQueueInsertService.insertMainOrderNotifyQueueIfNesscery(order.getId(), order.getConsumerId());
        OrdersDto finalyOrder = this.getOrder(order.getId(), order.getConsumerId());
        this.duibaEventsDispatcher.dispatchEvent(new OrdersEvent(OrdersEvent.OrdersEventType.OnOrderSuccess, order));
    }

    public void makeSuccess(final Long orderId, final Long consumerId) throws Exception {
        OrdersDto order = this.getOrder(orderId, consumerId);
        this.doWork(order);
        this.flowworkStatusChangeService.markSuccessComplete(orderId, consumerId);
        this.flowworkEngine.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                SuccessFlowWorker.this.flowworkEngine.getGoingListener().onComplete(orderId, consumerId);
            }
        });
    }

    @Override
    public NodeType getMyNodeType() {
        return NodeType.Success;
    }
}

