/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierProductDto;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.EnlianSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.GoukaQBSupplier2;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.TencentQBSupplier;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.SupplierConnector;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierProductsService;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QBSupplierConnector
extends SupplierConnector {
    @Autowired
    private SupplierProductsService supplierProductsService;
    @Autowired
    private TencentQBSupplier tencentQBSupplier;
    @Autowired
    private EnlianSupplier2 enlianSupplier2;
    @Autowired
    private GoukaQBSupplier2 goukaQBSupplier2;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;
    public static final String QQ = "qq";

    @Override
    public void asyncSupplierExchange(Long orderId, Long consumerId, Supplier.SupplierCallback callback, ExecutorService es) {
        SupplierData.SupplierExchangeRequest req = null;
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so = this.supplierOrdersService.find(order.getSupplierOrderId());
        SupplierProductDto supplier = this.supplierProductsService.find(so.getSupplierProductId());
        String qq = order.getBizParams().split(":")[0];
        Integer quantity = order.getQuantity();
        if (supplier.getSupplier().equals("qb-tencent")) {
            req = TencentQBSupplier.buildRequestData(so.getDuibaOrderNum(), qq, quantity);
            this.tencentQBSupplier.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if (supplier.getSupplier().equals("qb-enlian")) {
            req = EnlianSupplier2.buildRequestData(so.getDuibaOrderNum(), qq, quantity);
            this.enlianSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        } else if (supplier.getSupplier().equals("qb-gouka")) {
            req = GoukaQBSupplier2.buildRequestData(so.getDuibaOrderNum(), qq, quantity);
            this.goukaQBSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
        }
    }

    public SupplierData.SupplierOrderStatus callbackProcess(Long orderId, Long consumerId, HttpServletRequest request) throws Exception {
        SupplierData.SupplierOrderStatus status = null;
        String orderNum = null;
        if ("enlian".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.enlianSupplier2.callbackParse(request);
            orderNum = request.getParameter("merOrderId");
        } else if ("gouka".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
            status = this.goukaQBSupplier2.callbackParse(request);
            orderNum = request.getParameter("orderno");
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
        }
        if (!this.isMatchSupplierOrder(orderId, consumerId, orderNum)) {
            throw new Exception("\u8ba2\u5355\u53f7\u4e0e\u4e3b\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
        String params = "";
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            params = params + (String)entry.getKey() + "=" + ((String[])entry.getValue())[0];
        }
        so4u.setSupplierInfo(params);
        this.supplierOrdersService.update(so4u);
        if (!status.isSuccess()) {
            if (status.isFail()) {
                if ("gouka".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
                    String err_msg = URLDecoder.decode(request.getParameter("rechargeresult"), "gb2312");
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setErrorMessage(err_msg);
                    o4u.setError4Admin("\u5361\u5355:" + err_msg);
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, o4u.getErrorMessage(), o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                } else if ("enlian".equalsIgnoreCase(request.getAttribute("fromSupplier").toString())) {
                    OrdersDto o4u = new OrdersDto(orderId);
                    o4u.setErrorMessage("\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Admin("\u5361\u5355\uff1a\u4e0a\u6e38\u901a\u77e5\u5931\u8d25\u3002");
                    o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002");
                    o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), consumerId, null, o4u.getErrorMessage(), o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
                }
            } else if (status.isProcessing() || status.isNotExist()) {
                // empty if block
            }
        }
        return status;
    }
}

