/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.api.dto.supplier_order.SupplierOrderDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.supplier_order.SupplierOrdersService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SupplierConnector {
    private static Logger log = LoggerFactory.getLogger(SupplierConnector.class);
    @Autowired
    protected SupplierOrdersService supplierOrdersService;
    @Autowired
    protected OrderReadManagerBo orderReadManagerBo;

    public abstract void asyncSupplierExchange(Long var1, Long var2, Supplier.SupplierCallback var3, ExecutorService var4);

    protected boolean isMatchSupplierOrder(Long orderId, Long consumerId, String orderNum) {
        if (orderNum != null && orderNum.startsWith("duiba")) {
            List<SupplierOrderDto> list = this.supplierOrdersService.findAllByDuibaOrderNum(orderNum);
            if (list.size() > 0) {
                SupplierOrderDto so = list.get(0);
                OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
                if (!so.getId().equals(order.getSupplierOrderId())) {
                    log.error("\u4e0a\u6e38\u901a\u77e5\u5f02\u5e38,\u56de\u8c03\u5df2\u8fc7\u671f\uff1aorderId=" + order.getId());
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

