/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.service.exchange.supplier.Supplier;
import cn.com.duiba.order.center.biz.service.exchange.supplier.SupplierData;
import cn.com.duiba.order.center.biz.service.exchange2.supplier.impl.VirtualSupplier2;
import cn.com.duiba.order.center.biz.service.orders.consumer.OrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.orders.flowwork.impl.supplier.SupplierConnector;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VirtualConnector
extends SupplierConnector {
    private static Logger log = LoggerFactory.getLogger(VirtualConnector.class);
    @Autowired
    private VirtualSupplier2 virtualSupplier2;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private OrdersTextChangeService ordersTextChangeService;

    @Override
    public void asyncSupplierExchange(Long orderId, Long consumerId, Supplier.SupplierCallback callback, ExecutorService es) {
        OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
        if (order.getConsumerPayPrice() > 0L && !"pay_success".equals(order.getConsumerPayStatus())) {
            log.error("asyncSupplierExchange   \u52a0\u94b1\u8d2d\u5546\u54c1\u5728\u8fdb\u884c\u5411\u4e0a\u6e38\u5151\u6362\u65f6\u5fc5\u987b\u662f  \u4ed8\u8d39\u6210\u529f\u7684\u3002\u4e0d\u7136   \u4e0d\u5141\u8bb8\u8d70\u4e0a\u6e38\u5151\u6362");
            return;
        }
        SupplierData.SupplierExchangeRequest req = VirtualSupplier2.buildRequestData(order.getOrderNum(), order.getBizParams());
        this.virtualSupplier2.asyncSubmit(req, orderId, consumerId, callback, es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SupplierData.SupplierOrderStatus callbackProcess(Long orderId, HttpServletRequest request) throws Exception {
        SupplierData.SupplierOrderStatus status = this.virtualSupplier2.callbackParse(request);
        String creditsStr = request.getParameter("credits");
        if (status.isSuccess()) {
            if (StringUtils.isNotBlank((String)creditsStr)) {
                String orderNum = request.getParameter("orderNum");
                OrdersDto order = this.orderReadManagerBo.findByOrderNum(orderNum);
                this.remoteConsumerService.updateCredits(order.getConsumerId(), Long.valueOf(creditsStr));
            }
            return status;
        }
        if (status.isFail()) {
            String orderNum = request.getParameter("orderNum");
            OrdersDto order = this.orderReadManagerBo.findByOrderNum(orderNum);
            try {
                if (StringUtils.isNotBlank((String)creditsStr)) {
                    this.remoteConsumerService.updateCredits(order.getConsumerId(), Long.valueOf(creditsStr));
                }
                SupplierData.SupplierOrderStatus supplierOrderStatus = status;
                return supplierOrderStatus;
            }
            catch (Exception e) {
                log.error("makeFail \u5904\u7406\u5931\u8d25", (Throwable)e);
            }
            finally {
                String err_msg = request.getParameter("errorMsg");
                OrdersDto o4u = new OrdersDto(orderId);
                if (err_msg == null) {
                    err_msg = "";
                }
                o4u.setErrorMessage(err_msg);
                o4u.setError4Admin("\u865a\u62df\u5546\u54c1\u5f00\u53d1\u8005\u5151\u6362\u5931\u8d25\uff0c\u539f\u56e0:" + err_msg);
                o4u.setError4Developer("\u5151\u6362\u5931\u8d25\u3002" + err_msg);
                o4u.setError4Consumer("\u5151\u6362\u5931\u8d25\u3002" + err_msg);
                this.ordersTextChangeService.updateErrorMessageAndFailType(o4u.getId(), order.getConsumerId(), null, o4u.getErrorMessage(), o4u.getError4Consumer(), o4u.getError4Developer(), o4u.getError4Admin());
            }
        } else if (status.isProcessing() || status.isNotExist()) {
            // empty if block
        }
        return status;
    }
}

