/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.orders.mirror.impl;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.order.center.biz.bo.OrderReadManagerBo;
import cn.com.duiba.order.center.biz.dao.orders.master.MasterOrdersMirrorSimpleDao;
import cn.com.duiba.order.center.biz.entity.orders.OrdersEntity;
import cn.com.duiba.order.center.biz.service.orders.mirror.OrdersMirrorSyncService;
import cn.com.duiba.order.center.biz.service.orders.mirror.OrdersSyncFixThread;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ordersMirrorSyncService")
public class OrdersMirrorSyncServiceImpl
implements OrdersMirrorSyncService {
    @Autowired
    private MasterOrdersMirrorSimpleDao masterOrdersMirrorSimpleDAO;
    @Autowired
    private OrdersSyncFixThread ordersSyncFixThread;
    @Autowired
    private OrderReadManagerBo orderReadManagerBo;
    private static Logger log = LoggerFactory.getLogger(OrdersMirrorSyncServiceImpl.class);

    @Override
    public boolean syncByOrderId(Long orderId, Long consumerId) {
        try {
            OrdersDto order = this.orderReadManagerBo.find(orderId, consumerId);
            if (order == null) {
                return false;
            }
            int rows = this.masterOrdersMirrorSimpleDAO.update4sync(order.getAppId(), (OrdersEntity)BeanUtils.copy((Object)order, OrdersEntity.class));
            if (rows == 0) {
                this.masterOrdersMirrorSimpleDAO.insert4sync(order.getAppId(), (OrdersEntity)BeanUtils.copy((Object)order, OrdersEntity.class));
            }
            return true;
        }
        catch (Exception e) {
            log.error("syncByOrderId error ,orderId=" + orderId, (Throwable)e);
            return false;
        }
    }

    @Override
    public void syncByOrderIdRetryOnFail(Long orderId, Long consumerId) {
        boolean success = this.syncByOrderId(orderId, consumerId);
        if (!success) {
            this.ordersSyncFixThread.addNeetSyncOrder(orderId, consumerId);
        }
    }
}

