/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.support;

import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThreadPoolDuibaService {
    public static final int PriorityHigh = 10;
    public static final int PriorityNormal = 5;
    public static final int PriorityLow = 1;
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolDuibaService.class);
    private static final int PoolMaxThread = 50;
    private static final ThreadPoolDuibaService service = new ThreadPoolDuibaService();
    private final PriorityBlockingQueue<Runnable> workQueue = new PriorityBlockingQueue();
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.SECONDS, this.workQueue);

    public static ThreadPoolDuibaService get() {
        return service;
    }

    private ThreadPoolDuibaService() {
    }

    public void submit(Runnable runnable, int priority) {
        this.pool.execute(new DuibaRunnable(runnable, priority));
    }

    public JSONObject dumpDetail() {
        JSONObject o = new JSONObject();
        o.put("runningStat", (Object)this.getRunningStat());
        o.put("waitRunStat", (Object)this.getWaitRunStat());
        return o;
    }

    public int dumpSize() {
        return this.getRunningStat() + this.getWaitRunStat();
    }

    public boolean isBusy() {
        int size = this.dumpSize();
        return size > 100;
    }

    public Integer getRunningStat() {
        return this.pool.getActiveCount();
    }

    public Integer getWaitRunStat() {
        return this.pool.getQueue().size();
    }

    public class DuibaRunnable
    implements Runnable,
    Comparable<DuibaRunnable> {
        private int priority;
        private Runnable runnable;

        public DuibaRunnable(Runnable runnable, int priority) {
            Assert.notNull((Object)runnable);
            this.runnable = runnable;
            this.priority = priority;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public int compareTo(DuibaRunnable o) {
            if (this.getPriority() < o.getPriority()) {
                return 1;
            }
            if (this.getPriority() > o.getPriority()) {
                return -1;
            }
            return 0;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

