/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.service.activity.ActivityOrderService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteActivityOrderServiceImpl
implements RemoteActivityOrderService {
    @Autowired
    private ActivityOrderService activityOrderService;

    public DubboResult<String> createOrder(ActivityOrderDto orderDto) {
        ActivityOrderEntity entity = (ActivityOrderEntity)BeanUtils.copy((Object)orderDto, ActivityOrderEntity.class);
        String orderNum = this.activityOrderService.createOrder(entity);
        return DubboResult.successResult((Object)orderNum);
    }

    public DubboResult<ActivityOrderDto> findByOrderNum(String orderNum) {
        ActivityOrderEntity entity = this.activityOrderService.findByOrderNum(orderNum);
        ActivityOrderDto dto = (ActivityOrderDto)BeanUtils.copy((Object)entity, ActivityOrderDto.class);
        return DubboResult.successResult((Object)dto);
    }

    public DubboResult<Boolean> consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        boolean ret = this.activityOrderService.consumeCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        boolean ret = this.activityOrderService.consumeCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
        boolean ret = this.activityOrderService.addCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
        boolean ret = this.activityOrderService.addCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> exchangeStatusToWait(String orderNum) {
        boolean ret = this.activityOrderService.exchangeStatusToWait(orderNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> exchangeStatusToSuccess(String orderNum) {
        boolean ret = this.activityOrderService.exchangeStatusToSuccess(orderNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> exchangeStatusToFail(String orderNum) {
        boolean ret = this.activityOrderService.exchangeStatusToFail(orderNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> exchangeStatusToOverdue(String orderNum) {
        boolean ret = this.activityOrderService.exchangeStatusToOverdue(orderNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> updateDeveloperBizId(String orderNum, String developerBizId) {
        boolean ret = this.activityOrderService.updateDeveloperBizId(orderNum, developerBizId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> updateAddDeveloperBizId(String orderNum, String developerBizId) {
        boolean ret = this.activityOrderService.updateAddDeveloperBizId(orderNum, developerBizId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<ActivityOrderDto> findByDeveloperBizId(Long appId, String developerBizId) {
        return DubboResult.failResult((String)"\u901a\u8fc7\u5f00\u53d1\u8005\u8ba2\u5355\u53f7\u67e5\u5355\u63a5\u53e3\u5df2\u505c\u7528");
    }

    public DubboResult<Boolean> updateMainOrderNum(String orderNum, String mainOrderNum) {
        boolean ret = this.activityOrderService.updateMainOrderNum(orderNum, mainOrderNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Integer> findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String actvityType) {
        Integer ret = this.activityOrderService.findConsumerDuibaActivityNum(consumerId, duibaActivityId, actvityType);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<ActivityOrderDto>> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String actvityType) {
        List<ActivityOrderEntity> ret = this.activityOrderService.findConsumerDuibaActivityNumList(consumerId, duibaActivityIds, actvityType);
        ArrayList<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
        for (ActivityOrderEntity entity : ret) {
            ActivityOrderDto dto = (ActivityOrderDto)BeanUtils.copy((Object)entity, ActivityOrderDto.class);
            dtos.add(dto);
        }
        return DubboResult.successResult(dtos);
    }

    public DubboResult<List<ActivityOrderDto>> findByInOrderNums(long consumerId, List<String> orderNums) {
        List<ActivityOrderEntity> ret = this.activityOrderService.findByOrderNums(consumerId, orderNums);
        ArrayList<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
        for (ActivityOrderEntity entity : ret) {
            ActivityOrderDto dto = (ActivityOrderDto)BeanUtils.copy((Object)entity, ActivityOrderDto.class);
            dtos.add(dto);
        }
        return DubboResult.successResult(dtos);
    }

    public DubboResult<List<String>> findByExpirationTime(String expirationTime, String activityType) {
        List<String> ret = this.activityOrderService.findByExpirationTime(expirationTime, activityType);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<Long>> findOptionIds(Long consumerId, Long appId, String activityType) {
        List<Long> ret = this.activityOrderService.findOptionIds(consumerId, appId, activityType);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<ActivityOrderDto>> findByAppIdWithPage(Map<String, Object> queryMap) {
        List<ActivityOrderEntity> ret = this.activityOrderService.findByAppIdWithPage(queryMap);
        ArrayList<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
        for (ActivityOrderEntity entity : ret) {
            ActivityOrderDto dto = (ActivityOrderDto)BeanUtils.copy((Object)entity, ActivityOrderDto.class);
            dtos.add(dto);
        }
        return DubboResult.successResult(dtos);
    }

    public DubboResult<Integer> getCountByAppId(Map<String, Object> queryMap) {
        Integer ret = this.activityOrderService.getCountByAppId(queryMap);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<List<Map<String, Long>>> findFailByActivity4App(List<Long> activityIds, Long appId) {
        List<Map<String, Long>> ret = this.activityOrderService.findFailByActivity4App(activityIds, appId);
        return DubboResult.successResult(ret);
    }
}

