package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersSimpleDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.tool.IdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by yansen on 16/9/22.
 */
@Component
public class MainOrderSimpleHandle {

    @Autowired
    private OrdersSimpleDao ordersSimpleDao;

    public OrdersEntity find(Long id, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersSimpleDao.find(id,consumerId,tableName);
    }

    public OrdersEntity findByOrderNum(String orderNum) {
        if (!orderNum.contains(IdGenerator.chash)) {
            throw new RuntimeException("此订单号不能查询此库");
        }
        int cindex = orderNum.indexOf(IdGenerator.chash);
        String tableSuffix = orderNum.substring(cindex + 1, cindex + 5);
        String tableName=BaseOrderTool.getTableNameBySuffix(tableSuffix);
        return ordersSimpleDao.findByOrderNum(orderNum,tableName);
    }
}
