package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderSimpleService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class RemoteConsumerOrderSimpleServiceImpl implements RemoteConsumerOrderSimpleService {

    @Autowired
    private OrderSimpleService orderSimpleService;

    /**
     * 根据订单id和用户id查询订单
     *
     * @param id
     * @param consumerId
     * @return
     */
    @Override
    public DubboResult<OrdersDto> find(Long id, Long consumerId) {
        return DubboResult.successResult(BeanUtils.copy(orderSimpleService.find(id, consumerId),OrdersDto.class));
    }

    /**
     * 根据订单唯一编号查询订单
     *
     * @param orderNum
     * @return
     */
    @Override
    public DubboResult<OrdersDto> findByOrderNum(String orderNum) {
        return DubboResult.successResult(BeanUtils.copy(orderSimpleService.findByOrderNum(orderNum),OrdersDto.class));
    }
}
