package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import cn.com.duiba.order.center.biz.handle.MainOrderJumpHandle;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/21.
 */
@Service
public class OrderJumpService {
    @Autowired
    private MainOrderJumpHandle mainOrderJumpHandle;

    @Autowired
    private OrderSyncService orderSyncService;

    /**
     * 创建订单started->兑吧付款complete
     */
    public int jumpCreateStarted2DuibaPayComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpCreateStarted2DuibaPayComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 创建订单started->开发都付款完成 complete
     */
    public int jumpCreateStarted2DeveloperPayComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpCreateStarted2DeveloperPayComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }


    /**
     * 开发者付款  started-> 兑吧付款完成 complete
     */
    public int jumpDeveloperPayStarted2DuibaPayComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpDeveloperPayStarted2DuibaPayComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
    /**
     * 扣积分started->用户付款complete
     */
    public int jumpConsumeCreditsStarted2ConsumerPayComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpConsumeCreditsStarted2ConsumerPayComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
    /**
     * 扣积分started->审核complete
     */
    public int jumpConsumeCreditsStarted2AuditComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpConsumeCreditsStarted2AuditComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
    /**
     * 上游兑换started->售后complete
     */
    public int jumpSupplierExchangeStarted2AfterSendComplete(Long orderId, Long consumerId)throws BusinessException{
        int ret=mainOrderJumpHandle.jumpSupplierExchangeStarted2AfterSendComplete(orderId,consumerId);
        if(ret!=1){
            throw new BusinessException("状态变更失败");
        }
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
}
