/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCreator {
    @Autowired
    private MainOrderSimpleHandle MainOrderSimpleHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeOrder(OrdersEntity order) throws Exception {
        block8: {
            try {
                TimeProfile.enter("insertOrder");
                if (order.getId() != null) {
                    throw new Exception("\u8ba2\u5355\u5df2\u7ecf\u6709\u4e3b\u952eid\uff0c\u65e0\u6cd5\u521b\u5efa");
                }
                if (this.isFree(order)) {
                    this.MainOrderSimpleHandle.takeOrderFree(order);
                    break block8;
                }
                if (this.isDuibaTakeMoney(order)) {
                    this.MainOrderSimpleHandle.takeOrderDuibaTakeMOney(order);
                    break block8;
                }
                if (this.isTakeMoney(order)) {
                    this.MainOrderSimpleHandle.takeOrderTakeMoney(order);
                    break block8;
                }
                if (this.isConsumerPay(order)) {
                    this.MainOrderSimpleHandle.takeOrderConsumerPay(order);
                    break block8;
                }
                throw new Exception("\u6263\u8d39\u4ef7\u683c\u4e0d\u6b63\u786e");
            }
            finally {
                TimeProfile.release();
            }
        }
    }

    private boolean isFree(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isDuibaTakeMoney(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() > 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isTakeMoney(OrdersEntity order) {
        return order.getActualPrice() > 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isConsumerPay(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() > 0L;
    }

    protected boolean isNeedAudit(Integer auditPricePerConsumer, int actualPrice, String chargeMode) {
        if ("api".equals(chargeMode)) {
            return false;
        }
        if ("turntable".equals(chargeMode)) {
            return false;
        }
        if (auditPricePerConsumer == null) {
            return false;
        }
        return actualPrice >= auditPricePerConsumer && actualPrice > 0;
    }
}

