/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersSimpleDao;
import cn.com.duiba.order.center.biz.dao.orderhouse.OrderHouseSimpleDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import cn.com.duiba.order.center.biz.tool.IdGenerator;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.paycenter.client.PayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MainOrderSimpleHandle {
    @Autowired
    private OrdersSimpleDao ordersSimpleDao;
    @Autowired
    private OrderHouseSimpleDao orderHouseSimpleDao;
    @Autowired
    private PayCenterServiceClient payCenterServiceClient;
    @Autowired
    private RemoteIDMakerService remoteIDMakerService;
    @Autowired
    private OrderSyncService orderSyncService;

    public OrdersEntity findById(Long id, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return this.ordersSimpleDao.findById(id, tableName);
    }

    public OrdersEntity findByOrderNum(String orderNum) {
        if (!orderNum.contains("C")) {
            throw new RuntimeException("\u6b64\u8ba2\u5355\u53f7\u4e0d\u80fd\u67e5\u8be2\u6b64\u5e93");
        }
        int cindex = orderNum.indexOf("C");
        String tableSuffix = orderNum.substring(cindex + 1, cindex + 5);
        String tableName = BaseOrderTool.getTableNameBySuffix(tableSuffix);
        return this.ordersSimpleDao.findByOrderNum(orderNum, tableName);
    }

    public OrdersEntity select4updatelock(Long orderId, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return this.ordersSimpleDao.select4updatelock(orderId, consumerId, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(OrdersEntity order) throws Exception {
        try {
            TimeProfile.enter("insert");
            if (StringUtils.isBlank((String)order.getPayStatus()) || StringUtils.isBlank((String)order.getDuibaPayStatus()) || StringUtils.isBlank((String)order.getConsumerPayStatus())) {
                throw new StatusException(0, "\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            long sequence = this.getSequenceId();
            long id = Long.valueOf(sequence + "" + IdGenerator.get1024Suffix(order.getConsumerId()));
            String orderNum = IdGenerator.generate(sequence, order.getConsumerId());
            order.setId(id);
            order.setOrderNum(orderNum);
            order.setTableName(BaseOrderTool.getTableNameStr(order.getConsumerId()));
            int flag = this.ordersSimpleDao.insert(order);
            if (flag != 1) {
                throw new Exception("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
            }
        }
        finally {
            TimeProfile.release();
        }
        this.orderSyncService.sync(order.getId(), order.getConsumerId());
    }

    public void takeOrderFree(OrdersEntity order) throws Exception {
        this.insert(order);
    }

    public void takeOrderDuibaTakeMOney(OrdersEntity order) throws Exception {
        this.insert(order);
    }

    public void takeOrderTakeMoney(OrdersEntity order) throws Exception {
        this.checkAccountMoneyByDevelopId(order);
        this.insert(order);
    }

    public void takeOrderConsumerPay(OrdersEntity order) throws Exception {
    }

    private Long getSequenceId() {
        try {
            TimeProfile.enter("getSequenceId");
            DubboResult id = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.ORDER.getType());
            if (id.isSuccess()) {
                Long l = (Long)id.getResult();
                return l;
            }
            throw new RuntimeException("ID\u751f\u6210\u5931\u8d25");
        }
        finally {
            TimeProfile.release();
        }
    }

    private void checkAccountMoneyByDevelopId(OrdersEntity order) throws Exception {
        RpcResult rpcResult = this.payCenterServiceClient.getBalance(order.getDeveloperId());
        if (!rpcResult.isOpSuccess()) {
            throw new RuntimeException("\u4ece\u652f\u4ed8\u4e2d\u5fc3\u83b7\u53d6\u91d1\u989d \u5931\u8d25 ", (Throwable)rpcResult.getRpcException());
        }
        if ((Long)rpcResult.getResult() < (long)order.getActualPrice().intValue()) {
            throw new StatusException(2);
        }
    }

    public OrdersEntity findById(Long id) {
        String tableSuffix = BaseOrderTool.getTableSuffixByOrderId(id);
        if (StringUtils.isEmpty((String)tableSuffix)) {
            return this.orderHouseSimpleDao.find(id);
        }
        return this.ordersSimpleDao.findById(id, BaseOrderTool.getTableNameBySuffix(tableSuffix));
    }
}

