/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.dao.credits.ConsumerExchangeRecordDao;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import cn.com.duiba.order.center.biz.entity.CrecordSyncMessage;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerExchangeRecordService {
    private static Logger log = LoggerFactory.getLogger(ConsumerExchangeRecordService.class);
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConsumerExchangeRecordDao consumerExchangeRecordDao;

    public void insert(ConsumerExchangeRecordDto consumerExchangeRecordDto) {
        ConsumerExchangeRecordEntity entity = (ConsumerExchangeRecordEntity)BeanUtils.copy((Object)consumerExchangeRecordDto, ConsumerExchangeRecordEntity.class);
        entity.setId(this.getSequenceID(new ConsumerExchangeRecordSequenceEntity()));
        this.consumerExchangeRecordDao.insert(entity);
        consumerExchangeRecordDto.setId(entity.getId());
        this.sendSyncMessage(entity.getConsumerId(), entity.getId());
    }

    private long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity) {
        this.consumerExchangeRecordDao.getSequenceID(consumerExchangeRecordSequenceEntity);
        return consumerExchangeRecordSequenceEntity.getId();
    }

    public void sendSyncMessage(Long consumerId, Long id) {
        try {
            CrecordSyncMessage message = new CrecordSyncMessage();
            message.setConsumerId(consumerId);
            message.setId(id);
            String body = JSONObject.toJSONString((Object)message);
            this.messageService.sendMsg(this.topicConstant.getTopicCrecord(), body);
        }
        catch (Exception e) {
            log.error("sendSyncMessage error: [consumerId " + consumerId + "] [crecordId " + id + "]", (Throwable)e);
        }
    }
}

