package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.SupplierProductDto;
import cn.com.duiba.order.center.biz.dao.credits.SupplierProductsDao;
import cn.com.duiba.order.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class SupplierProductsService {
    @Autowired
    private SupplierProductsDao supplierProductsDao;

    public SupplierProductDto findBySupplier(String supplier){
        return BeanUtils.copy(supplierProductsDao.findBySupplier(supplier),SupplierProductDto.class);
    }

    public SupplierProductDto insert(SupplierProductDto supplierProductDto){
        SupplierProductEntity entity=BeanUtils.copy(supplierProductDto,SupplierProductEntity.class);
        supplierProductsDao.insert(entity);
        supplierProductDto.setId(entity.getId());
        return supplierProductDto;
    }

    public SupplierProductDto findById(Long id){
        return BeanUtils.copy(supplierProductsDao.findById(id),SupplierProductDto.class);
    }


}
