package cn.com.duiba.order.center.biz.handle;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.biz.dao.BaseActivityOrderDaoTool;
import cn.com.duiba.order.center.biz.dao.activity.ActivityOrderDao;
import cn.com.duiba.order.center.biz.dao.activityhouse.ActivityOrderHouseDao;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Component
public class ActivityOrderHandle {

	@Resource
	private RemoteIDMakerService remoteIDMakerService;
	
	@Autowired
	private ActivityOrderDao activityOrderDao;
	@Autowired
	private ActivityOrderHouseDao activityOrderHouseDao;
	

	public void insert(ActivityOrderEntity entity) {
		//TODO ID生成器类型
		DubboResult<Long> ret = remoteIDMakerService.getNextID(IDMakerTypeEnums.ACTIVITY_ORDER.getType());
		if (!ret.isSuccess()) {
			throw new RuntimeException("ID生成失败");
		}
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(entity.getConsumerId());
		String orderNum = ret.getResult() + "" + suffix;
		entity.setSuffix(suffix);
		System.out.println("suffix="+suffix);
		entity.setOrderNum(orderNum);
		activityOrderDao.insert(entity);
	}

	public ActivityOrderEntity find(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.find(suffix,orderNum);
	}

	public int updateCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateCreditsSuccess(suffix,orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId,ActivityOrderDto.ConsumeCreditsSuccess);
	}

	public int updateCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, ActivityOrderDto.ConsumeCreditsFail);
	}
	
	public int updateAddCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddCreditsSuccess(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, ActivityOrderDto.AddCreditsSuccess);
	}

	public int updateAddCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddCreditsFail(suffix, orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer, ActivityOrderDto.AddCreditsFail);
	}

	public int updateExchangeStatusWait(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeWait);
	}

	public int updateExchangeStatusSuccess(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeSuccess);
	}

	public int updateExchangeStatusFail(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeFail);
	}

	public int updateExchangeStatusOverdue(String orderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateExchangeStatus(suffix, orderNum, ActivityOrderDto.ExchangeOverdue);
	}

	public int updateDeveloperBizId(String orderNum, String bizId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateDeveloperBizId(suffix,orderNum, bizId);
	}
	
	public int updateAddDeveloperBizId(String orderNum, String bizId) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateAddDeveloperBizId(suffix,orderNum, bizId);
	}

	public int updateMainOrderNum(String orderNum, String mainOrderNum) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffixByOrderNum(orderNum);
		return activityOrderDao.updateMainOrderNum(suffix, orderNum, mainOrderNum);
	}

	public int countConsumerJoinNum(long consumerId, long duibaActivityId, String activityType) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.countConsumerJoinNum(suffix, consumerId, duibaActivityId, activityType);
	}

	public List<ActivityOrderEntity> findConsumerJoinList(long consumerId, List<Long> duibaActivityIds, String activityType) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findConsumerJoinList(suffix, consumerId, duibaActivityIds, activityType);
	}

	public List<ActivityOrderEntity> findByOrderNums(long consumerId, List<String> orderNums) {
		String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
		return activityOrderDao.findByOrderNums(suffix, orderNums);
	}
	
	public List<String> findByExpirationTime(String expirationTime,String activityType){
		return activityOrderHouseDao.findByExpirationTime(expirationTime,activityType);
	}
}
