package cn.com.duiba.order.center.biz.handle;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersSimpleDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import cn.com.duiba.order.center.biz.tool.IdGenerator;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.paycenter.client.PayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/22.
 */
@Component
public class MainOrderSimpleHandle {

    @Autowired
    private OrdersSimpleDao ordersSimpleDao;
    
//    @Autowired
//	private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    
    @Autowired
	private PayCenterServiceClient payCenterServiceClient;
    
    @Autowired
	private RemoteIDMakerService remoteIDMakerService;
    
    @Autowired
    private OrderSyncService orderSyncService;

    public OrdersEntity findById(Long id, Long consumerId) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersSimpleDao.findById(id,consumerId,tableName);
    }

    public OrdersEntity findByOrderNum(String orderNum) {
        if (!orderNum.contains(IdGenerator.chash)) {
            throw new RuntimeException("此订单号不能查询此库");
        }
        int cindex = orderNum.indexOf(IdGenerator.chash);
        String tableSuffix = orderNum.substring(cindex + 1, cindex + 5);
        String tableName=BaseOrderTool.getTableNameBySuffix(tableSuffix);
        return ordersSimpleDao.findByOrderNum(orderNum,tableName);
    }

    public OrdersEntity select4updatelock(Long orderId,Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersSimpleDao.select4updatelock(orderId,consumerId,tableName);
    }
    
    public void insert(OrdersEntity order)throws Exception{
		try {
			TimeProfile.enter("insert");
			if(StringUtils.isBlank(order.getPayStatus())||StringUtils.isBlank(order.getDuibaPayStatus())||StringUtils.isBlank(order.getConsumerPayStatus())){
				throw new StatusException(0,"状态不正确");
			}
			long sequence = getSequenceId();
			long id = Long.valueOf(sequence+""+IdGenerator.get1024Suffix(order.getConsumerId()));
			String orderNum = IdGenerator.generate(sequence, order.getConsumerId());
			order.setId(id);
			order.setOrderNum(orderNum);
			order.setTableName(BaseOrderTool.getTableNameStr(order.getConsumerId()));
			int flag = ordersSimpleDao.insert(order);
			if(flag != 1){
				throw new Exception("订单没有创建");
			}
		} finally {
			TimeProfile.release();
		}
		orderSyncService.sync(order.getId(), order.getConsumerId());
	}
    

    public void takeOrderFree(OrdersEntity order) throws Exception{
    	insert(order);
    }
    
    public void takeOrderDuibaTakeMOney(OrdersEntity order) throws Exception{
    	//校验帐户金额够不够
//		DuibaRemainingMoneyDO duibaM =duibaRemainingMoneyDAO.findDuibaAccountMoney();
//		Long money=duibaM.getMoney();
//		if(money<order.getDuibaActualPrice()){
//			throw new StatusException(StatusException.CodeBalanceNotEnough);
//		}
		insert(order);
    }
    
    public void takeOrderTakeMoney(OrdersEntity order) throws Exception{
    	/*** 对接支付中心，加入新代码 begin ***/
		checkAccountMoneyByDevelopId(order);
		
		//初始定单支付状态弄成unKnow_pay状态。
		insert(order);
    }
    
    /**
     * 加钱购
     * @param order
     * @throws Exception
     */
    public void takeOrderConsumerPay(OrdersEntity order) throws Exception{
    	//TODO 本次迁移Q币业务不涉及加钱购情况
    	//生成主定单
//    	insert(order);
		//生成子定单
//		AmbSubOrdersDO sub=ambSubOrdersService.createAmbSubOrder(order, key);
		
//		ordersTextChangeDAO.updateSubOrderIdById(order.getId(), order.getConsumerId(), sub.getId());
		//生成加速定单
//		int ret=ambOrderFastService.createOrderFastMaxTime(order.getId(), order.getConsumerId());
//		if(ret==0){
//			throw new Exception("加速  定单已经存在");
//		}
    }
    
    
    private Long getSequenceId(){
		try{
			TimeProfile.enter("getSequenceId");
			DubboResult<Long> id = remoteIDMakerService.getNextID(IDMakerTypeEnums.ORDER.getType());
			if(id.isSuccess()){
				return id.getResult();
			}else{
				throw new RuntimeException("ID生成失败");
			}
		}finally{
			TimeProfile.release();
		}
	}
    
    private void checkAccountMoneyByDevelopId(OrdersEntity order) throws Exception{
    	RpcResult<Long> rpcResult = payCenterServiceClient.getBalance(order.getDeveloperId());

		// 调用失败
		if (!rpcResult.isOpSuccess())
		{
//			PayCenterLog.info("call payCenterServiceClient.getBalance final failed  throw exception");
			throw new RuntimeException("从支付中心获取金额 失败 ",rpcResult.getRpcException());
		}
		if (rpcResult.getResult() < order.getActualPrice())
		{
			throw new StatusException(StatusException.CodeBalanceNotEnough);
		}
    }
    
}
