package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersStatusChangeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by yansen on 16/9/22.
 */
@Component
public class OrdersStatusChangeHandler {

    @Autowired
    private OrdersStatusChangeDao ordersStatusChangeDao;

    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.updatePayOrderStatus(orderId,consumerId,payStatus,tableName);
    }

    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeConsumeSuccess(orderId,consumerId,tableName);
    }

    public Integer doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeConsumeFail(orderId,consumerId,failType,error4consumer,error4developer,error4admin,tableName);
    }

    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAmbConsumerPayStatusPaySuccess(orderId,consumerId,tableName);
    }

    public Integer doAuditPass(Long orderId,Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAuditPass(orderId,consumerId,tableName);
    }

    public Integer doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAuditReject(orderId,consumerId,error4consumer,error4developer,error4admin,failType,tableName);
    }

}
