package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteSupplierOrdersService;
import cn.com.duiba.order.center.biz.service.credits.SupplierOrdersService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/26.
 */
@Service
public class RemoteSupplierOrdersServiceImpl implements RemoteSupplierOrdersService {

    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Override
    public DubboResult<SupplierOrderDto> insert(SupplierOrderDto supplierOrderDto) {
        return DubboResult.successResult(supplierOrdersService.insert(supplierOrderDto));
    }

    @Override
    public DubboResult<Void> update(SupplierOrderDto supplierOrderDto) {
        supplierOrdersService.update(supplierOrderDto);
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<SupplierOrderDto> find(Long id) {
        return DubboResult.successResult(supplierOrdersService.find(id));
    }
}
