package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import cn.com.duiba.order.center.biz.handle.OrdersStatusChangeHandler;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class OrdersStatusChangeService {
    @Autowired
    private OrdersStatusChangeHandler ordersStatusChangeHandler;

    @Autowired
    private OrderSyncService orderSyncService;

    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus) {
        Integer ret=ordersStatusChangeHandler.updatePayOrderStatus(orderId,consumerId,payStatus);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId){
        Integer ret=ordersStatusChangeHandler.doMakeConsumeSuccess(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public Integer doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin){
        Integer ret=ordersStatusChangeHandler.doMakeConsumeFail(orderId,consumerId,failType,error4consumer,error4developer,error4admin);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**加钱购支付成功 后 更新加钱购支付状态  为  pay_success**/
    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId) {
        Integer ret=ordersStatusChangeHandler.doAmbConsumerPayStatusPaySuccess(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public Integer doAuditPass(Long orderId, Long consumerId) {
        Integer ret=ordersStatusChangeHandler.doAuditPass(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    public Integer doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType) {
        Integer ret=ordersStatusChangeHandler.doAuditReject(orderId,consumerId,error4consumer,error4developer,error4admin,failType);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }
}
