package cn.com.duiba.order.center.biz.bo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.api.dto.OrderAuditMessageDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.mainorder.orderhouse.OrderHouseSimpleService;
import cn.com.duiba.order.center.biz.service.message.MessageService;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by yansen on 16/9/29.
 */
@Service
public class AuditBo {

    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;
    @Autowired
    private OrderHouseSimpleService orderHouseSimpleService;

    public void doAuditPass(Long orderId) {
        OrderAuditMessageDto messageDto=new OrderAuditMessageDto(orderId,true);
        messageService.sendMsg(topicConstant.getTopicOrderAudit(), JSONObject.toJSONString(messageDto));
    }

    public void doAuditReject(Long orderId) {
//        OrdersDto order = orderHouseSimpleService.findById(orderId);
        OrderAuditMessageDto messageDto=new OrderAuditMessageDto(orderId,false);
        messageService.sendMsg(topicConstant.getTopicOrderAudit(), JSONObject.toJSONString(messageDto));
    }
}
