package cn.com.duiba.order.center.biz.dao.orderconsumer;

import org.apache.ibatis.annotations.Param;

/**
 * Created by yansen on 16/9/22.
 */
public interface OrdersStatusChangeDao {

    public Integer updatePayOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("payStatus") String payStatus, @Param("tableName") String tableName);

    public Integer doMakeConsumeSuccess(@Param("orderId")Long orderId,  @Param("consumerId")Long consumerId, @Param("tableName") String tableName);

    public Integer doMakeConsumeFail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("failType") Integer failType, @Param("error4consumer") String error4consumer, @Param("error4developer") String error4developer, @Param("error4admin") String error4admin, @Param("tableName") String tableName);

    /**加钱购支付成功 后 更新加钱购支付状态  为  pay_success**/
    public Integer doAmbConsumerPayStatusPaySuccess(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * 使用where语句锁
     * 	where id=#{orderId} and audit_status='wait' and status='consume_success'
     * @param orderId
     * @return
     */
    public int doAuditPass(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 使用where语句锁
     * 	where id=#{orderId} and audit_status='wait' and status='consume_success'
     * @param orderId
     * @return
     */
    //
    public int doAuditReject(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("error4consumer") String error4consumer,@Param("error4developer") String error4developer,@Param("error4admin") String error4admin,@Param("failType") Integer failType, @Param("tableName") String tableName);

    public int doMakeSuccess(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("payStatus") String payStatus,@Param("duibaPayStatus") String duibaPayStatus,@Param("consumerPayStatus") String consumerPayStatus, @Param("tableName") String tableName) ;

    /**
     * where id=#{orderId} and status!='success' and status!='fail'
     * @param orderId
     * @return
     * @throws Exception
     * payStatus  如果null, 动态SQL不更新字段。
     * duibaPayStatus 如果为null,  动态SQL不更新字段。
     * consumerPayStatus 如果为null,动态SQL不更新字段
     */

    public int doMakeFail(@Param("orderId")Long orderId, @Param("consumerId")Long consumerId, @Param("payStatus")String payStatus,@Param("duibaPayStatus")String duibaPayStatus,@Param("consumerPayStatus")String consumerPayStatus,@Param("consumerPaybackPrice") Long consumerPaybackPrice,@Param("tableName") String tableName);

    public Integer updateDuibaPayOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("payStatus") String duibaPayStatus,@Param("tableName") String tableName);

    /**
     * 更新重填字段，只能使用一次
     * @param orderId
     * @param supplierOrderId
     * @param bizParams
     * @param brief
     * @return
     */
    public Integer doUpdateAllowInputUsed(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("supplierOrderId") Long supplierOrderId,@Param("bizParams") String bizParams,@Param("brief") String brief,@Param("tableName") String tableName);
}
