package cn.com.duiba.order.center.biz.entity;


import java.util.Calendar;
import java.util.Date;

public class ConsumerExchangeRecordEntity {


	private Long id;
	private Long consumerId;
	private Integer type;
	private Long orderId;
	private Long relationId;
	private Date gmtCreate;
	private Date gmtModified;
	private Long switchs;
	private String json;
	private Date overDue;

	private String tableName;

	public ConsumerExchangeRecordEntity() {

	}

	public ConsumerExchangeRecordEntity(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public ConsumerExchangeRecordEntity(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			switchs = (long) 0;
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.YEAR, 100);
			overDue = cal.getTime();
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getSwitchs() {
		return switchs;
	}

	public void setSwitchs(Long switchs) {
		this.switchs = switchs;
	}

	public boolean getSwitchs(Integer type) {
		int v = 1 << type;
		long ret = switchs & v;
		return ret != 0;
	}

	public void disableSwitchs(Integer type) {
		int v = 1 << type;
		v = ~v;
		switchs = switchs & v;
	}

	public void enableSwitchs(Integer type) {
		int v = 1 << type;
		switchs = switchs | v;
	}

	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public Date getOverDue() {
		return overDue;
	}

	public void setOverDue(Date overDue) {
		this.overDue = overDue;
	}
}
