package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QBcreator extends BaseCreator {

	private static final Logger log = LoggerFactory.getLogger(QBcreator.class);

	@Autowired
	private TopicConstant topicConstant;
	
	@Autowired
	private MessageService messageService;
	
	/**
	 * Q币普通兑换下单操作
	 * @param order 订单对象
	 * @param supplierProductId Q币供应商id
	 * @param params http参数
	 * @throws Exception
	 */
	public void createOrder(OrdersEntity order,Long supplierProductId, RequestParams params) throws Exception{
		
		if(order == null){
			throw new Exception("订单为空");
		}
		
		// 创建订单
		takeOrder(order);
		
		// 订单异步处理消息
		OrderCreateContext orderCreateContext = new OrderCreateContext();
		orderCreateContext.setOrderId(order.getId());
		orderCreateContext.setConsumerId(order.getConsumerId());
		orderCreateContext.setParams(params);
		orderCreateContext.setChargeMode(order.getChargeMode());
		orderCreateContext.setSupplierProductId(supplierProductId);
		orderCreateContext.setTimestamp(System.currentTimeMillis());
		log.error("topicConstant.getQbOrderCreatePart()"+topicConstant.getQbOrderCreatePart());
		messageService.sendMsg(topicConstant.getQbOrderCreatePart(), JSONObject.toJSONString(orderCreateContext));
		log.error("send message success");
	}
	
//	private boolean isQQNumValid(String qq){
//		boolean flag = false;
//		  try{
//		    Pattern regex = Pattern.compile("^[0-9]*$");
//		    Matcher matcher = regex.matcher(qq);
//		    flag = matcher.matches();
//		   }catch(Exception e){
//		    flag = false;
//		   }
//		  return flag;
//	}
	

}
