package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersTextChangeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@Component
public class OrdersTextChangeHandle {

    @Autowired
    private OrdersTextChangeDao ordersTextChangeDao;

    /**
     * 更新订单错误信息，状态，错误类型
     *
     * @param orderId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                 String error4Consumer, String error4Developer, String error4Admin) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateErrorMessageAndFailType(orderId, consumerId, failType, errorMessage, error4Consumer, error4Developer, error4Admin, tableName);
    }

    /**
     * 更新最后发送时间
     *
     * @param orderId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateLastSendTime(orderId,consumerId,lastSendTime,tableName);
    }

    /**
     * 更新开发者订单号
     * @param orderId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(Long orderId,Long consumerId, String developBizId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateDevelopBizId(orderId,consumerId,developBizId,tableName);
    }

    /**
     * 更新上游订单
     * @param orderId
     * @param supplierOrderId
     */
    public Integer updateSupplierOrderId(Long orderId,  Long consumerId, Long supplierOrderId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersTextChangeDao.updateSupplierOrderId(orderId,consumerId,supplierOrderId,tableName);
    }
}
