package cn.com.duiba.order.center.biz.remoteservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.service.activity.ActivityOrderService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by houwen on 16/7/27
 */
@Service
public class RemoteActivityOrderServiceImpl implements RemoteActivityOrderService {

//	private static Logger log = LoggerFactory.getLogger(RemoteActivityOrderServiceImpl.class);

	@Autowired
	private ActivityOrderService activityOrderService;

	@Override
	public DubboResult<String> createOrder(ActivityOrderDto orderDto) {
		ActivityOrderEntity entity = BeanUtils.copy(orderDto, ActivityOrderEntity.class);
		String orderNum = activityOrderService.createOrder(entity);
		return DubboResult.successResult(orderNum);
	}

	@Override
	public DubboResult<ActivityOrderDto> findByOrderNum(String orderNum) {
		ActivityOrderEntity entity = activityOrderService.findByOrderNum(orderNum);
		ActivityOrderDto dto = BeanUtils.copy(entity, ActivityOrderDto.class);
		return DubboResult.successResult(dto);
	}

	@Override
	public DubboResult<Boolean> consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		boolean ret = activityOrderService.consumeCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> consumeCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		boolean ret = activityOrderService.consumeCreditsSuccessDowngrade(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		boolean ret = activityOrderService.consumeCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
		return DubboResult.successResult(ret);
	}
	
	@Override
	public DubboResult<Boolean> addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		boolean ret = activityOrderService.addCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		boolean ret = activityOrderService.addCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> exchangeStatusToWait(String orderNum) {
		boolean ret = activityOrderService.exchangeStatusToWait(orderNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> exchangeStatusToSuccess(String orderNum) {
		boolean ret = activityOrderService.exchangeStatusToSuccess(orderNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> exchangeStatusToFail(String orderNum) {
		boolean ret = activityOrderService.exchangeStatusToFail(orderNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> exchangeStatusToOverdue(String orderNum) {
		boolean ret = activityOrderService.exchangeStatusToOverdue(orderNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> updateDeveloperBizId(String orderNum, String developerBizId) {
		boolean ret = activityOrderService.updateDeveloperBizId(orderNum, developerBizId);
		return DubboResult.successResult(ret);
	}
	
	@Override
	public DubboResult<Boolean> updateAddDeveloperBizId(String orderNum, String developerBizId) {
		boolean ret = activityOrderService.updateAddDeveloperBizId(orderNum, developerBizId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<ActivityOrderDto> findByDeveloperBizId(Long appId, String developerBizId) {
		return DubboResult.failResult("通过开发者订单号查单接口已停用");
	}

	@Override
	public DubboResult<Boolean> updateMainOrderNum(String orderNum, String mainOrderNum) {
		boolean ret = activityOrderService.updateMainOrderNum(orderNum, mainOrderNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String actvityType) {
		Integer ret = activityOrderService.findConsumerDuibaActivityNum(consumerId, duibaActivityId, actvityType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ActivityOrderDto>> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String actvityType) {
		List<ActivityOrderEntity> ret = activityOrderService.findConsumerDuibaActivityNumList(consumerId, duibaActivityIds, actvityType);
		List<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
		for(ActivityOrderEntity entity : ret){
			ActivityOrderDto dto = BeanUtils.copy(entity, ActivityOrderDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}
	
	@Override
	public DubboResult<ActivityOrderDto> findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType,
			String start, String end) {
		ActivityOrderEntity entity = activityOrderService.findConsumerDuibaActivity4day(consumerId, duibaActivityId, activityType, start, end);
		ActivityOrderDto dto = BeanUtils.copy(entity, ActivityOrderDto.class);
		return DubboResult.successResult(dto);
	}

	@Override
	public DubboResult<List<ActivityOrderDto>> findByInOrderNums(long consumerId, List<String> orderNums) {
		List<ActivityOrderEntity> ret = activityOrderService.findByOrderNums(consumerId, orderNums);
		List<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
		for(ActivityOrderEntity entity : ret){
			ActivityOrderDto dto = BeanUtils.copy(entity, ActivityOrderDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}
	
	@Override
	public DubboResult<List<String>> findByExpirationTime(String expirationTime,String activityType){
		List<String> ret = activityOrderService.findByExpirationTime(expirationTime,activityType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<Long>> findOptionIds(Long consumerId, Long appId,
			String activityType) {
		List<Long> ret = activityOrderService.findOptionIds(consumerId, appId, activityType);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<ActivityOrderDto>> findByAppIdWithPage(Map<String, Object> queryMap) {
		List<ActivityOrderEntity> ret = activityOrderService.findByAppIdWithPage(queryMap);
		List<ActivityOrderDto> dtos = new ArrayList<ActivityOrderDto>();
		for(ActivityOrderEntity entity : ret){
			ActivityOrderDto dto = BeanUtils.copy(entity, ActivityOrderDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}

	@Override
	public DubboResult<Integer> getCountByAppId(Map<String, Object> queryMap) {
		Integer ret = activityOrderService.getCountByAppId(queryMap);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<Map<String,Long>>> findFailByActivity4App(List<Long> activityIds, Long appId) {
		List<Map<String,Long>> ret = activityOrderService.findFailByActivity4App(activityIds, appId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> updateAddCredits(String orderNum, Long credits) {
		boolean ret = activityOrderService.updateAddCredits(orderNum, credits);
		return DubboResult.successResult(ret);
	}

	
}
