package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteTransactionBoService;
import cn.com.duiba.order.center.biz.bo.TransactionBo;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/10/9.
 */
@Service
public class RemoteTransactionBoServiceImpl implements RemoteTransactionBoService {

    @Autowired
    private TransactionBo transactionBo;

    @Override
    public DubboResult<Boolean> doMakeConsumeSuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult(transactionBo.doMakeConsumeSuccess(orderId, consumerId));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) {
        try {
            return DubboResult.successResult(transactionBo.doMakeConsumeFail(orderId, consumerId, failType, error4consumer, error4developer, error4admin));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doAmbPaySuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult(transactionBo.doAmbPaySuccess(orderId, consumerId));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doAuditReject(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult(transactionBo.doAuditReject(orderId, consumerId));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doMakeSuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult(transactionBo.doMakeSuccess(orderId, consumerId));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doMakeFail(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult(transactionBo.doMakeFail(orderId, consumerId));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> doUpdateAllowInputUsed(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams, String brief) {
        try {
            return DubboResult.successResult(transactionBo.doUpdateAllowInputUsed(orderId, consumerId, supplierOrder, bizParams, brief));
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> createPayBackRecordAtMakeFail(OrdersDto orders) {
        try {
            transactionBo.createPayBackRecordAtMakeFail(orders);
            return DubboResult.successResult(null);
        } catch (BusinessException e) {
            return DubboResult.failResult(e.getMessage());
        }
    }
}
