package cn.com.duiba.order.center.biz.service.activity;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.biz.entity.ActivityOrderEntity;
import cn.com.duiba.order.center.biz.handle.ActivityOrderHandle;

@Service
public class ActivityOrderService {

	@Autowired
	private ActivityOrderHandle activityOrderHandle;
	@Autowired
	private DataSyncActivityOrderService dataSyncActivityOrderService;

	/**
     * 创建活动订单
     * @param activityOrderDto
     * @return
     */
	public String createOrder(ActivityOrderEntity entity) {
		activityOrderHandle.insert(entity);
		dataSyncActivityOrderService.dataSync(entity.getOrderNum());
		return entity.getOrderNum();
	}

	/**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
	public ActivityOrderEntity findByOrderNum(String orderNum) {
		return activityOrderHandle.find(orderNum);
	}

	/**
     * 订单扣积分成功
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
	public boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		int ret = activityOrderHandle.updateCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}
	
	/**
     * 订单扣积分成功--降级
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
	public boolean consumeCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		int ret = activityOrderHandle.updateCreditsSuccessDowngrade(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}
	
	/**
     * 订单加积分成功
     * @param orderNum 订单唯一编号
     * @param optionDto 中奖奖项信息
     * @return
     */
	public boolean addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId) {
		int ret = activityOrderHandle.updateAddCreditsSuccess(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 订单扣积分失败
     * @param orderNum 订单唯一编号
     * @param optionDto 奖项信息（如谢谢参与或空）
     * @return
     */
	public boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		int ret = activityOrderHandle.updateCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}
	
	/**
     * 订单加积分失败
     * @param orderNum 订单唯一编号
     * @param optionDto 奖项信息（如谢谢参与或空）
     * @return
     */
	public boolean addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer) {
		int ret = activityOrderHandle.updateAddCreditsFail(orderNum, activityOptionId, activityOptionName, activityOptionType, activityOptionFacePrice, appItemId, itemId, gid, gtype, couponId, error4admin, error4developer, error4consumer);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 订单置为待领奖状态
     * @param orderNum 订单唯一编号
     * @return
     */
	public boolean exchangeStatusToWait(String orderNum) {
		int ret = activityOrderHandle.updateExchangeStatusWait(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 订单置为领奖成功
     * @param orderNum 订单唯一编号
     * @return
     */
	public boolean exchangeStatusToSuccess(String orderNum) {
		int ret = activityOrderHandle.updateExchangeStatusSuccess(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 订单置为领奖失败
     * @param orderNum 订单唯一编号
     * @return
     */
	public boolean exchangeStatusToFail(String orderNum) {
		int ret = activityOrderHandle.updateExchangeStatusFail(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 订单置为未领奖过期
     * @param orderNum 订单唯一编号
     * @return
     */
	public boolean exchangeStatusToOverdue(String orderNum) {
		int ret = activityOrderHandle.updateExchangeStatusOverdue(orderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 根据订单唯一编号修改扣积分开发者订单号
     * @param orderNum 订单唯一编号
     * @param developerBizId 开发者订单号
     * @return
     */
	public boolean updateDeveloperBizId(String orderNum, String developerBizId) {
		int ret = activityOrderHandle.updateDeveloperBizId(orderNum, developerBizId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}
	
	/**
     * 根据订单唯一编号修改加积分开发者订单号
     * @param orderNum 订单唯一编号
     * @param developerBizId 开发者订单号
     * @return
     */
	public boolean updateAddDeveloperBizId(String orderNum, String developerBizId) {
		int ret = activityOrderHandle.updateAddDeveloperBizId(orderNum, developerBizId);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 修改主订单号
     * @param orderNum 订单唯一编号
     * @param mainOrderNum 主订单唯一编号
     * @return
     */
	public boolean updateMainOrderNum(String orderNum, String mainOrderNum) {
		int ret = activityOrderHandle.updateMainOrderNum(orderNum, mainOrderNum);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}

	/**
     * 用户参与兑吧活动次数
     * @param consumerId 用户ID
     * @param activityId 活动ID
     * @return
     */
	public Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType) {
		return activityOrderHandle.countConsumerJoinNum(consumerId, duibaActivityId,activityType);
	}

	/**
     * 用户参与兑吧活动订单明细
     * @param consumerId 用户ID
     * @param duibaActivityIds 活动ID集合
     * @return 
     */
	public List<ActivityOrderEntity> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType) {
		return activityOrderHandle.findConsumerJoinList(consumerId, duibaActivityIds,activityType);
	}
	
	public ActivityOrderEntity findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType,
			String start, String end){
		return activityOrderHandle.findConsumerDuibaActivity4day(consumerId, duibaActivityId, activityType, start, end);
	}

	/**
     * 根据订单号批量查询订单
     * @param consumerId
     * @param orderNums
     * @return
     */
	public List<ActivityOrderEntity> findByOrderNums(long consumerId, List<String> orderNums) {
		return activityOrderHandle.findByOrderNums(consumerId, orderNums);
	}

	/**
	 * 根据时间段分页查询未领奖状态活动订单
	 * @param expirationTime 过期时间
	 * @return
	 */
	public List<String> findByExpirationTime(String expirationTime,String activityType){
		return activityOrderHandle.findByExpirationTime(expirationTime,activityType);
	}
	
	/**
     * 根据参数获取中奖的奖项id
     * @param consumerId 消费者id
     * @param appId app的id
     * @param activityType 活动类型
     * @return
     */
	public List<Long> findOptionIds(Long consumerId, Long appId, String activityType) {
		return activityOrderHandle.findOptionIds(consumerId, appId, activityType);
	}
	
	public List<ActivityOrderEntity> findByAppIdWithPage(Map<String, Object> queryMap){
		return activityOrderHandle.findByAppIdWithPage(queryMap);
	}
	
	public Integer getCountByAppId(Map<String, Object> queryMap){
		return activityOrderHandle.getCountByAppId(queryMap);
	}
	
	public List<Map<String,Long>> findFailByActivity4App(List<Long> activityIds, Long appId){
		return activityOrderHandle.findFailByActivity4App(activityIds, appId);
	}
	
	public Boolean updateAddCredits(String orderNum, Long credits){
		int ret = activityOrderHandle.updateAddCredits(orderNum, credits);
		if (ret < 1) {
			return false;
		}
		dataSyncActivityOrderService.dataSync(orderNum);
		return true;
	}
	
}
