package cn.com.duiba.order.center.biz.constant;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.util.Random;

/**
 * 消息Topic 队列配置项
 */
@Configuration
public class TopicConstant {
	
	/**
	 * 活动订单数据同步队列名称
	 */
	@Value("${trade.topic.activity.order}")
	private String topicActivityOrderDataSync;

	@Value("${trade.topic.orders.data.sync}")
	private String topicOrdersDataSync;

	@Value("${trade.topic.crecord.data.sync}")
	private String topicCrecord;
	@Value("${trade.topic.orders.qbcreate}")
	private String qbOrderCreate;

	@Value("${trade.topic.orders.audit}")
	private String topicOrderAudit;

	public String getTopicActivityOrderDataSync() {
		return topicActivityOrderDataSync;
	}

	public String getTopicOrdersDataSync() {
		return topicOrdersDataSync;
	}


	/** 多队列个数 */
	@Value("${trade.queue.topic.number}")
	public int topicNumber;
	
	/**
	 * 获取随机Topic
	 * @return
	 */
	private int getTopicPart() {
		Random random = new Random();
		return random.nextInt(topicNumber);
	}
	
	public String getQbOrderCreatePart() {
		int i = getTopicPart();
		return qbOrderCreate + i;
	}

	public String getTopicOrderAudit() {
		return topicOrderAudit;
	}

	public String getTopicCrecord() {
		return topicCrecord;
	}

}