package cn.com.duiba.order.center.biz.dao.orderconsumer;

import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
public interface OrdersTextChangeDao {

    /**
     * 更新订单错误信息，状态，错误类型
     *
     * @param orderId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public Integer updateErrorMessageAndFailType(@Param("orderId") Long orderId,@Param("consumerId") Long consumerId,@Param("failType") Integer failType, @Param("errorMessage") String errorMessage,
                                                 @Param("error4Consumer") String error4Consumer,@Param("error4Developer") String error4Developer,@Param("error4Admin") String error4Admin, @Param("tableName") String tableName);

    /**
     * 更新最后发送时间
     * @param orderId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("lastSendTime") Date lastSendTime, @Param("tableName") String tableName);

    /**
     * 更新开发者订单号
     * @param orderId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("developBizId") String developBizId,@Param("tableName") String tableName);

    /**
     * 更新上游订单
     * @param orderId
     * @param supplierOrderId
     */
    public Integer updateSupplierOrderId(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("supplierOrderId") Long supplierOrderId,@Param("tableName") String tableName);
}
