package cn.com.duiba.order.center.biz.exchangecreator;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.order.center.biz.tool.TimeProfile;

/**
 * 普通兑换下单基础类
 * @author zhaodongxue
 *
 */
public class BaseCreator {
	
	
	@Autowired
	private MainOrderSimpleHandle MainOrderSimpleHandle;
	
	protected void takeOrder(OrdersEntity order) throws Exception{
		try {
			TimeProfile.enter("insertOrder");
			if(order.getId()!=null){
				throw new Exception("订单已经有主键id，无法创建");
			}
			
			if(isFree(order)){
				MainOrderSimpleHandle.takeOrderFree(order);
			}else if(isDuibaTakeMoney(order)){
				MainOrderSimpleHandle.takeOrderDuibaTakeMOney(order);
			}else if(isTakeMoney(order)){
				MainOrderSimpleHandle.takeOrderTakeMoney(order);
			}else if(isConsumerPay(order)){
				MainOrderSimpleHandle.takeOrderConsumerPay(order);
			}else{
				throw new Exception("扣费价格不正确");
			}
		} finally {
			TimeProfile.release();
		}
	}
	
	/**
	 * 是否免费
	 * @param order
	 * @return
	 */
	private boolean isFree(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()==0 && order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否兑吧扣钱
	 * @param order
	 * @return
	 */
	private boolean isDuibaTakeMoney(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()>0 &&order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否扣钱
	 * @param order
	 * @return
	 */
	private boolean isTakeMoney(OrdersEntity order){
		if(order.getActualPrice()>0 && order.getDuibaActualPrice()==0 && order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否消费者加钱购
	 * @param order
	 * @return
	 */
	private boolean isConsumerPay(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()==0&& order.getConsumerPayPrice()>0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否需要审核
	 * @param auditPricePerConsumer 用户单笔免审核上限
	 * @param actualPrice 商品实际价格
	 * @param chargeMode 兑换方式
	 * @return
	 */
	protected boolean isNeedAudit(Integer auditPricePerConsumer, int actualPrice , String chargeMode){
		// 如果是api请求，无须审核
		if (OrdersDto.ChargeModeApi.equals(chargeMode)) {
			return false;
		}
		//如果是大转盘领奖，无须审核
		if(OrdersDto.ChargeModeTurntable.equals(chargeMode)){
			return false;
		}
		
		if(auditPricePerConsumer == null){
			return false;
		}
		
		if (actualPrice >= auditPricePerConsumer && actualPrice > 0) {
			return true;
		} else {
			return false;
		}
	}

}
