package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import cn.com.duiba.order.center.biz.handle.OrdersTextChangeHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class OrdersTextChangeService {

    @Autowired
    private OrdersTextChangeHandle ordersTextChangeHandle;

    /**
     * 更新订单错误信息，状态，错误类型
     *
     * @param orderId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public Integer updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                 String error4Consumer, String error4Develper, String error4Admin) {
        return ordersTextChangeHandle.updateErrorMessageAndFailType(orderId,consumerId,failType,errorMessage,error4Consumer,error4Develper,error4Admin);
    }

    /**
     * 更新最后发送时间
     *
     * @param orderId
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        return ordersTextChangeHandle.updateLastSendTime(orderId,consumerId,lastSendTime);
    }

    /**
     * 更新开发者订单号
     * @param orderId
     * @param developBizId
     * @return
     */
    public Integer updateDevelopBizId(Long orderId,Long consumerId, String developBizId){
        return ordersTextChangeHandle.updateDevelopBizId(orderId,consumerId,developBizId);
    }

    /**
     * 更新上游订单
     * @param orderId
     * @param supplierOrderId
     */
    public Integer updateSupplierOrderId(Long orderId,  Long consumerId, Long supplierOrderId){
        return ordersTextChangeHandle.updateSupplierOrderId(orderId,consumerId,supplierOrderId);
    }
}
