package cn.com.duiba.order.center.biz.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * 尚缺dubbo插件，去除了http线程副本
 * @author zhaodongxue
 *
 */
public class TimeProfile {
	private static Logger log=LoggerFactory.getLogger(TimeProfile.class);
	private static ThreadLocal<Stack<TimeProfileStack>> stack=new ThreadLocal<Stack<TimeProfileStack>>();
	private static ThreadLocal<List<TimeProfileStack>> logs=new ThreadLocal<List<TimeProfileStack>>();
	static ThreadLocal<HttpServletRequest> request=new ThreadLocal<HttpServletRequest>();
	static int threshold=1;//超时时间，单位毫秒

	public static void enter(){
		enter("");
	}
	
	public static void enter(String tag){
		if(stack.get()==null){
			return;
		}
		TimeProfileStack t=new TimeProfileStack();
		t.setEnterTime(new Date());
		t.setTag(tag);
		t.setDeep(stack.get().size());
		
		t.index=logs.get().size()+stack.get().size();
		stack.get().push(t);
	}
	
	public static void release(){
		if(stack.get()==null){
			return;
		}
		TimeProfileStack t=stack.get().pop();
		t.setReleaseTime(new Date());
		logs.get().add(t);
	}
	
	public static void start(){
		stack.set(new Stack<TimeProfile.TimeProfileStack>());
		logs.set(new ArrayList<TimeProfile.TimeProfileStack>());
		enter();
	}
	
	public static void end(){
		TimeProfileStack t=stack.get().pop();
		t.setReleaseTime(new Date());
		logs.get().add(t);
		
		Long timeconsume=t.getReleaseTime().getTime()-t.getEnterTime().getTime();
		if(timeconsume>threshold){
			//输出日志
			StringBuffer sb=new StringBuffer();
			sb.append("TimeProfile timeout "+timeconsume+"ms ");
			List<TimeProfileStack> list=new ArrayList<TimeProfile.TimeProfileStack>(logs.get());
			Collections.sort(list, new Comparator<TimeProfileStack>() {
				@Override
				public int compare(TimeProfileStack o1, TimeProfileStack o2) {
					if(o1.index>o2.index){
						return 1;
					}else if(o1.index<o2.index){
						return -1;
					}
					return 0;
				}
			});
			for(TimeProfileStack s:list){
				sb.append("\r\n\t");
				for(int i=0;i<s.getDeep();i++){
					sb.append("-");
				}
				Long consume=s.getReleaseTime().getTime()-s.getEnterTime().getTime();
				sb.append(consume*100/timeconsume+"%");
				sb.append("  "+consume+"ms");
				if(s.getTag()!=null){
					sb.append("  "+s.getTag());
				}
				
				if(s.getStackTraceElement()!=null){
					StackTraceElement ste=s.getStackTraceElement();
					sb.append("  "+ste.getClassName()+"."+ste.getMethodName()+" line:"+ste.getLineNumber());
				}
			}
			log.error(sb.toString());
		}
		request.set(null);
		stack.set(null);
		logs.set(null);
	}
	/**
	 * dump堆栈信息
	 * @param ms 毫秒  ，超过此毫秒时才会dump
	 */
	public static String dump(long ms){
		if(logs.get()==null){
			return null;
		}
		TimeProfileStack t=stack.get().pop();
		t.setReleaseTime(new Date());
		logs.get().add(t);
		
		Long timeconsume=0L;
		for(TimeProfileStack s:logs.get()){
			if(s.deep==0){
				timeconsume+=s.getReleaseTime().getTime()-s.getEnterTime().getTime();
			}
		}
		if(timeconsume<ms){
			return null;
		}
		//输出日志
		StringBuffer sb=new StringBuffer();
		sb.append("TimeProfile timeout "+timeconsume+"ms ");
		List<TimeProfileStack> list=new ArrayList<TimeProfile.TimeProfileStack>(logs.get());
		Collections.sort(list, new Comparator<TimeProfileStack>() {
			@Override
			public int compare(TimeProfileStack o1, TimeProfileStack o2) {
				if(o1.index>o2.index){
					return 1;
				}else if(o1.index<o2.index){
					return -1;
				}
				return 0;
			}
		});
		for(TimeProfileStack s:list){
			Long consume=s.getReleaseTime().getTime()-s.getEnterTime().getTime();
			if(consume==0){
				continue;
			}
			sb.append("\r\n\t");
			for(int i=0;i<s.getDeep();i++){
				sb.append("  ");
			}
			sb.append("-");
			sb.append(consume*100/timeconsume+"%");
			sb.append("  "+consume+"ms");
			if(s.getTag()!=null){
				sb.append("  "+s.getTag());
			}
			
			if(s.getStackTraceElement()!=null){
				StackTraceElement ste=s.getStackTraceElement();
				sb.append("  "+ste.getClassName()+"."+ste.getMethodName()+" line:"+ste.getLineNumber());
			}
		}
		request.set(null);
		stack.set(null);
		logs.set(null);
		
		return sb.toString();
	}
	
	public static void main(String[] args) throws Exception {
		TimeProfile.start();
		try {
			Thread.sleep(1000);
			TimeProfile.enter("in");
			Thread.sleep(1000);
			TimeProfile.release();
		} finally{
			TimeProfile.release();
		}
		
		System.out.println(TimeProfile.dump(0));
	}
	
	public static class TimeProfileStack{
		private Date enterTime;
		private Date releaseTime;
		private int deep;
		private String tag;
		int index;
		private StackTraceElement stackTraceElement;
		public Date getEnterTime() {
			return enterTime;
		}
		public void setEnterTime(Date enterTime) {
			this.enterTime = enterTime;
		}
		public Date getReleaseTime() {
			return releaseTime;
		}
		public void setReleaseTime(Date releaseTime) {
			this.releaseTime = releaseTime;
		}
		public int getDeep() {
			return deep;
		}
		public void setDeep(int deep) {
			this.deep = deep;
		}
		public String getTag() {
			return tag;
		}
		public void setTag(String tag) {
			this.tag = tag;
		}
		public StackTraceElement getStackTraceElement() {
			return stackTraceElement;
		}
		public void setStackTraceElement(StackTraceElement stackTraceElement) {
			this.stackTraceElement = stackTraceElement;
		}
	}
}
