/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCreator {
    @Autowired
    private MainOrderSimpleHandle mainOrderSimpleHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeOrder(OrdersEntity order) throws Exception {
        block8: {
            try {
                TimeProfile.enter("insertOrder");
                if (order.getId() != null) {
                    throw new Exception("\u8ba2\u5355\u5df2\u7ecf\u6709\u4e3b\u952eid\uff0c\u65e0\u6cd5\u521b\u5efa");
                }
                if (this.isFree(order)) {
                    this.mainOrderSimpleHandle.takeOrderFree(order);
                    break block8;
                }
                if (this.isDuibaTakeMoney(order)) {
                    this.mainOrderSimpleHandle.takeOrderDuibaTakeMOney(order);
                    break block8;
                }
                if (this.isTakeMoney(order)) {
                    this.mainOrderSimpleHandle.takeOrderTakeMoney(order);
                    break block8;
                }
                if (this.isConsumerPay(order)) {
                    this.mainOrderSimpleHandle.takeOrderConsumerPay(order);
                    break block8;
                }
                throw new Exception("\u6263\u8d39\u4ef7\u683c\u4e0d\u6b63\u786e");
            }
            finally {
                TimeProfile.release();
            }
        }
    }

    protected OrdersEntity takePcgOrder(OrdersEntity order) throws Exception {
        try {
            TimeProfile.enter("takeOrderIntimes");
            if (order.getId() != null) {
                throw new Exception("\u8ba2\u5355\u5df2\u7ecf\u6709\u4e3b\u952eid\uff0c\u65e0\u6cd5\u521b\u5efa");
            }
            if (!this.isFree(order)) {
                if (this.isDuibaTakeMoney(order)) {
                    throw new BusinessException("\u6682\u4e0d\u652f\u6301");
                }
                if (this.isTakeMoney(order)) {
                    throw new BusinessException("\u6682\u4e0d\u652f\u6301");
                }
                if (this.isConsumerPay(order)) {
                    throw new BusinessException("\u6682\u4e0d\u652f\u6301");
                }
                throw new BusinessException("\u6263\u8d39\u4ef7\u683c\u4e0d\u6b63\u786e");
            }
            this.mainOrderSimpleHandle.takeOrderFree(order);
            if (order.getId() != null) {
                if ((order = this.mainOrderSimpleHandle.findById(order.getId(), order.getConsumerId())) == null) {
                    throw new BusinessException("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
                }
                OrdersEntity ordersEntity = order;
                return ordersEntity;
            }
            throw new BusinessException("\u8ba2\u5355\u6ca1\u6709\u521b\u5efa");
        }
        finally {
            TimeProfile.release();
        }
    }

    private boolean isFree(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isDuibaTakeMoney(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() > 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isTakeMoney(OrdersEntity order) {
        return order.getActualPrice() > 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() == 0L;
    }

    private boolean isConsumerPay(OrdersEntity order) {
        return order.getActualPrice() == 0 && order.getDuibaActualPrice() == 0 && order.getConsumerPayPrice() > 0L;
    }

    protected boolean isNeedAudit(Integer auditPricePerConsumer, int actualPrice, String chargeMode) {
        if ("api".equals(chargeMode)) {
            return false;
        }
        if ("turntable".equals(chargeMode)) {
            return false;
        }
        if (auditPricePerConsumer == null) {
            return false;
        }
        return actualPrice >= auditPricePerConsumer && actualPrice > 0;
    }
}

