/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.api.remoteservice.RemoteExchangeService;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.exchangecreator.AliPayCreator;
import cn.com.duiba.order.center.biz.exchangecreator.CouponCreator;
import cn.com.duiba.order.center.biz.exchangecreator.PcgCouponCreator;
import cn.com.duiba.order.center.biz.exchangecreator.PhoneBillCreator;
import cn.com.duiba.order.center.biz.exchangecreator.QBcreator;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteExchangeServiceImpl
implements RemoteExchangeService {
    @Autowired
    private QBcreator qBcreator;
    @Autowired
    private AliPayCreator aliPayCreator;
    @Autowired
    private PhoneBillCreator phoneBillCreator;
    @Autowired
    private CouponCreator couponCreator;
    @Autowired
    private PcgCouponCreator pcgCouponCreator;
    private static final Logger log = LoggerFactory.getLogger(RemoteExchangeServiceImpl.class);

    public DubboResult<OrdersDto> createQbOrder(OrdersDto orderDto, Long supplierProductId, RequestParams params) {
        OrdersEntity order = (OrdersEntity)BeanUtils.copy((Object)orderDto, OrdersEntity.class);
        try {
            this.qBcreator.createOrder(order, supplierProductId, params);
            orderDto.setId(order.getId());
            orderDto.setOrderNum(order.getOrderNum());
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            log.error("Qb exchange error = ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrdersDto> createAliPayOrder(OrdersDto orderDto, RequestParams params) {
        OrdersEntity order = (OrdersEntity)BeanUtils.copy((Object)orderDto, OrdersEntity.class);
        try {
            this.aliPayCreator.createOrder(order, params);
            orderDto.setId(order.getId());
            orderDto.setOrderNum(order.getOrderNum());
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            log.error("alipay exchange error = ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrdersDto> createPhoneBillOrder(OrdersDto orderDto, Long supplierProductId, RequestParams params) {
        OrdersEntity order = (OrdersEntity)BeanUtils.copy((Object)orderDto, OrdersEntity.class);
        try {
            this.phoneBillCreator.createOrder(order, supplierProductId, params);
            orderDto.setId(order.getId());
            orderDto.setOrderNum(order.getOrderNum());
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            log.error("phonebill exchange error = ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<OrdersDto> createCouponOrder(OrdersDto orderDto, Long couponId, RequestParams params) {
        OrdersEntity order = (OrdersEntity)BeanUtils.copy((Object)orderDto, OrdersEntity.class);
        try {
            this.couponCreator.createOrder(order, couponId, params);
            orderDto.setId(order.getId());
            orderDto.setOrderNum(order.getOrderNum());
            return DubboResult.successResult((Object)orderDto);
        }
        catch (Exception e) {
            log.error("coupon exchange error = ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult> createPcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param) {
        RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult result = new RemotePlatformCouponGoodsTakeOrderService.TakeOrderResult();
        try {
            OrdersDto order = this.pcgCouponCreator.takePcgOrder(param);
            if (order != null && order.getId() != null) {
                result.setSuccess(true);
                result.setOrderId(order.getId());
                return DubboResult.successResult((Object)result);
            }
            throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
        }
        catch (Exception e) {
            log.error("RemotePlatformCouponGoodsTakeOrderServiceImpl.takeOrder error,orderNum=" + param.getOrderNum() + ",pcgId=" + param.getPcgId(), (Throwable)e);
            result.setSuccess(false);
            result.setNeedRollback(true);
            return DubboResult.successResult((Object)result);
        }
    }
}

