/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.hdtool;

import cn.com.duiba.order.center.biz.dao.BaseActivityOrderDaoTool;
import cn.com.duiba.order.center.biz.dao.creditshdtool.CreditshdtoolDao;
import cn.com.duiba.order.center.biz.entity.HdtoolOrdersEntity;
import cn.com.duiba.order.center.biz.service.message.HdtoolMQSend;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditshdtoolService {
    @Autowired
    private CreditshdtoolDao creditshdtoolDao;
    @Autowired
    private HdtoolMQSend hdtoolMQSend;

    public HdtoolOrdersEntity findById(Long consumerId, Long id) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.findById(suffix, id);
    }

    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.countByConsumerIdAndOperatingActivityId(suffix, consumerId, operatingActivityId);
    }

    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.countByConsumerIdAndOperatingActivityIdAndDate(suffix, consumerId, operatingActivityId, start, end);
    }

    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.countFreeByConsumerIdAndOperatingActivityId(suffix, consumerId, operatingActivityId);
    }

    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(suffix, consumerId, operatingActivityId, start, end);
    }

    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.countByConsumerIdAndPrizeId(suffix, consumerId, operatingActivityId, prizeId);
    }

    public List<HdtoolOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.findByIds(suffix, ids);
    }

    public HdtoolOrdersEntity findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        return this.creditshdtoolDao.findByAppAndDeveloperBizId(suffix, appId, bizId);
    }

    public Integer updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        error4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
        error4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
        error4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
        int ret = this.creditshdtoolDao.updateExchangeStatusToFail(suffix, 3, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        error4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
        error4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
        error4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
        int ret = this.creditshdtoolDao.updateExchangeStatusToOverdue(suffix, 4, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        error4admin = StringUtils.substring((String)error4admin, (int)0, (int)200);
        error4developer = StringUtils.substring((String)error4developer, (int)0, (int)200);
        error4consumer = StringUtils.substring((String)error4consumer, (int)0, (int)200);
        int ret = this.creditshdtoolDao.updateStatusToFail(suffix, 2, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer doTakePrize(Long consumerId, Long id) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.doTakePrize(suffix, id);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer rollbackTakePrize(Long consumerId, Long id) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.rollbackTakePrize(suffix, id);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.updateLotteryResult(suffix, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId, 1, 1);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.updateLotteryLuckyResult(suffix, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId, 1, 1);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateDeveloperBizId(Long consumerId, long id, String bizId) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.updateDeveloperBizId(suffix, id, bizId);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public Integer updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        int ret = this.creditshdtoolDao.updateMainOrderId(suffix, id, mainOrderId, mainOrderNum);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    public HdtoolOrdersEntity insert(HdtoolOrdersEntity hdtoolOrdersEntity) {
        this.creditshdtoolDao.generateHdtoolOrderSequence(hdtoolOrdersEntity);
        long consumerId = hdtoolOrdersEntity.getConsumerId();
        String suffix = BaseActivityOrderDaoTool.getTableSuffix(consumerId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suffix", suffix);
        params.put("mirror", hdtoolOrdersEntity);
        this.creditshdtoolDao.insert(params);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, hdtoolOrdersEntity.getId());
        return hdtoolOrdersEntity;
    }
}

