/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.message;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.DataSyncMessage;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HdtoolMQSend {
    private static Logger log = LoggerFactory.getLogger(HdtoolMQSend.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;

    public void hdtoolSendDataSync(Long consumerId, Long hdOrderId) {
        DataSyncMessage message = new DataSyncMessage();
        message.setConsumerId(consumerId);
        message.setSubOrderId(hdOrderId);
        String json = JSONObject.toJSONString((Object)message);
        if (json.length() > message.getMaxBodyBytes()) {
            log.error("queueName:" + this.topicConstant.getTopicHdtoolDataSync() + ",json:[" + json + "] is too long,current:" + json.length() + ",max:" + message.getMaxBodyBytes() + ",will not send");
        }
        try {
            this.messageService.sendMsg(this.topicConstant.getTopicHdtoolDataSync(), json);
        }
        catch (Exception e) {
            log.error("hdtool   send message is error [hdtoolSendDataSync] : consumerId: " + consumerId + "  hdOrderId: " + hdOrderId, (Throwable)e);
        }
    }
}

