/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.dcommons.flowwork.RemotePlatformCouponGoodsTakeOrderService;
import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.exchangecreator.BaseCreator;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PcgCouponCreator
extends BaseCreator {
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;

    public OrdersDto takePcgOrder(RemotePlatformCouponGoodsTakeOrderService.PcgOrderParam param) throws Exception {
        OrdersDto order = new OrdersDto(true);
        order.setIp(param.getIp());
        order.setChargeMode("mall");
        order.setOrderNum(param.getOrderNum());
        order.setConsumerId(param.getConsumerId());
        order.setAppId(param.getAppId());
        order.setDeveloperId(param.getDeveloperId());
        order.setCouponId(param.getCouponId());
        order.setQuantity(Integer.valueOf(1));
        order.setStatus("create");
        order.setType("coupon");
        order.setActualPrice(Integer.valueOf(0));
        order.setPayStatus("none");
        order.setDuibaActualPrice(Integer.valueOf(0));
        order.setDuibaPayStatus("none");
        order.setConsumerPayPrice(Long.valueOf(0L));
        order.setConsumerPayStatus("none");
        order.setRelationType(Integer.valueOf(0));
        order.setRelationId(null);
        if (param.getCredits() <= 0L) {
            throw new BusinessException("\u79ef\u5206\u5fc5\u987b\u5927\u4e8e0");
        }
        order.setCredits(param.getCredits());
        order.setAuditStatus(OrdersDto.AuditStatusNotNeed);
        order.setItemId(param.getPcgId());
        order.setBrief(param.getBrief());
        order.setFacePrice(param.getFacePrice());
        order.setTypeInt(Integer.valueOf(GoodsTypeEnum.PLATFORM.getGtype()));
        try {
            TimeProfile.enter("takeOrderIntimes");
            OrdersEntity entity = (OrdersEntity)BeanUtils.copy((Object)order, OrdersEntity.class);
            this.takePcgOrder(entity);
            order.setId(entity.getId());
            order.setOrderNum(entity.getOrderNum());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TimeProfile.release();
        }
        RequestParams localRequestParam = new RequestParams();
        localRequestParam.setConsumerId(param.getConsumerId());
        localRequestParam.setCookies(param.getCookies());
        localRequestParam.setIp(param.getIp());
        localRequestParam.setUserAgent(param.getUserAgent());
        HashMap<String, Date> extraParam = new HashMap<String, Date>();
        extraParam.put("overDue", param.getOverDue());
        OrderCreateContext orderCreateContext = new OrderCreateContext();
        orderCreateContext.setOrderId(order.getId());
        orderCreateContext.setConsumerId(order.getConsumerId());
        orderCreateContext.setParams(localRequestParam);
        orderCreateContext.setChargeMode(order.getChargeMode());
        orderCreateContext.setParamsMap(extraParam);
        orderCreateContext.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        this.messageService.sendMsg(this.topicConstant.getPcgCouponOrderCreatePart(), JSONObject.toJSONString((Object)orderCreateContext));
        return order;
    }
}

