/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteTransactionBoService;
import cn.com.duiba.order.center.biz.bo.TransactionBo;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteTransactionBoServiceImpl
implements RemoteTransactionBoService {
    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(RemoteTransactionBoServiceImpl.class);
    @Autowired
    private TransactionBo transactionBo;

    public DubboResult<Boolean> doMakeConsumeSuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doMakeConsumeSuccess(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doMakeConsumeSuccess", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doMakeConsumeFail(orderId, consumerId, failType, error4consumer, error4developer, error4admin));
        }
        catch (BusinessException e) {
            log.error("doMakeConsumeFail", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doAmbPaySuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doAmbPaySuccess(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doAmbPaySuccess", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doAuditReject(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doAuditReject(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doAuditReject", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doMakeSuccess(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doMakeSuccess(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doMakeSuccess", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doMakeFail(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doMakeFail(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doMakeFail", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doUpdateAllowInputUsed(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams, String brief) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doUpdateAllowInputUsed(orderId, consumerId, supplierOrder, bizParams, brief));
        }
        catch (BusinessException e) {
            log.error("doUpdateAllowInputUsed", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> createPayBackRecordAtMakeFail(OrdersDto orders) {
        try {
            this.transactionBo.createPayBackRecordAtMakeFail(orders);
            return DubboResult.successResult(null);
        }
        catch (BusinessException e) {
            log.error("createPayBackRecordAtMakeFail", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, SupplierOrderDto supplierOrder, String bizParams) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doUpdateAllowInputUsed4Object(orderId, consumerId, supplierOrder, bizParams));
        }
        catch (BusinessException e) {
            log.error("doUpdateAllowInputUsed4Object", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> doAmbStatusAfterSend(Long orderId, Long consumerId) {
        try {
            return DubboResult.successResult((Object)this.transactionBo.doAmbStatusAfterSend(orderId, consumerId));
        }
        catch (BusinessException e) {
            log.error("doAmbStatusAfterSend", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

