/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.biz.service.consumerrecord;

import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLogger;
import cn.com.duiba.boot.ext.autoconfigure.logger.DuiBaLoggerFactory;
import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import cn.com.duiba.order.center.biz.entity.CrecordSyncMessage;
import cn.com.duiba.order.center.biz.handle.ConsumerExchangeRecordHandle;
import cn.com.duiba.order.center.biz.service.message.MessageService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerExchangeRecordService {
    private static DuiBaLogger log = DuiBaLoggerFactory.getLogger(ConsumerExchangeRecordService.class);
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConsumerExchangeRecordHandle consumerExchangeRecordHandle;

    public void insert(ConsumerExchangeRecordDto consumerExchangeRecordDto) {
        ConsumerExchangeRecordEntity entity = (ConsumerExchangeRecordEntity)BeanUtils.copy((Object)consumerExchangeRecordDto, ConsumerExchangeRecordEntity.class);
        entity.setId(this.getSequenceID(new ConsumerExchangeRecordSequenceEntity()));
        this.consumerExchangeRecordHandle.insert(entity);
        consumerExchangeRecordDto.setId(entity.getId());
        this.sendSyncMessage(entity.getConsumerId(), entity.getId());
    }

    public ConsumerExchangeRecordEntity selectOneByMapCondition(Map<String, Object> map) {
        return this.consumerExchangeRecordHandle.selectOneByMapCondition(map);
    }

    public List<ConsumerExchangeRecordEntity> selectListByMapCondition(Map<String, Object> map) {
        return this.consumerExchangeRecordHandle.selectListByMapCondition(map);
    }

    public List<ConsumerExchangeRecordEntity> selectPageListByMapCondition(Map<String, Object> map) {
        return this.consumerExchangeRecordHandle.selectPageListByMapCondition(map);
    }

    public Boolean update(ConsumerExchangeRecordEntity entity) {
        int ret = this.consumerExchangeRecordHandle.update(entity);
        if (ret < 1) {
            return false;
        }
        this.sendSyncMessage(entity.getConsumerId(), entity.getId());
        return true;
    }

    private long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity) {
        this.consumerExchangeRecordHandle.getSequenceID(consumerExchangeRecordSequenceEntity);
        return consumerExchangeRecordSequenceEntity.getId();
    }

    private void sendSyncMessage(Long consumerId, Long id) {
        try {
            CrecordSyncMessage message = new CrecordSyncMessage();
            message.setConsumerId(consumerId);
            message.setId(id);
            String body = JSONObject.toJSONString((Object)message);
            this.messageService.sendMsg(this.topicConstant.getTopicCrecord(), body);
        }
        catch (Exception e) {
            log.error("sendSyncMessage error: [consumerId " + consumerId + "] [crecordId " + id + "]", (Throwable)e);
        }
    }
}

